using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_FLG // FLaG (yellow or blue flag changed)
    {
        private byte Size;		// 8
        private PacketTypeEnum Type;		// ISP_FLG
        private byte ReqI;		// 0
        public byte PLID;		// player's unique id

        public byte OffOn;		// 0 = off / 1 = on
        public RaceFlagEnum Flag;		// 1 = given blue / 2 = causing yellow
        public byte CarBehind;	// unique id of obstructed player
        private byte Sp3;

        public IS_FLG()
        {
            Size = 8;
            Type = PacketTypeEnum.ISP_FLG;
            ReqI = 0;
            Sp3 = 0;
        }
    }
}
