using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_CNL
    {
        private byte Size;		// 8
        private PacketTypeEnum Type;		// ISP_CNL
        private byte ReqI;		// 0
        public byte UCID;		// unique id of the connection which left

        public LeaveEnum Reason;		// leave reason (see below)
        public byte Total;		// number of connections including host
        private byte Sp2;
        private byte Sp3;

        public IS_CNL()
        {
            Size = 8;
            Type = PacketTypeEnum.ISP_CNL;
            ReqI = 0;
            Sp2 = 0;
            Sp3 = 0;
        }
    }
}
