using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    // IS_CCH : Camera CHange

    // To track cameras you need to consider 3 points

    // 1) The default camera : VIEW_DRIVER
    // 2) Player flags : CUSTOM_VIEW means VIEW_CUSTOM at start or pit exit
    // 3) IS_CCH : sent when an existing driver changes camera

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_CCH // Camera CHange
    {
        private byte Size;		// 8
        private PacketTypeEnum Type;		// ISP_CCH
        private byte ReqI;		// 0
        public byte PLID;		// player's unique id

        public ViewEnum Camera;		// view identifier (see below)
        private byte Sp1;
        private byte Sp2;
        private byte Sp3;

        public IS_CCH()
        {
            Size = 8;
            Type = PacketTypeEnum.ISP_CCH;
            ReqI = 0;
            Sp1 = 0;
            Sp2 = 0;
            Sp3 = 0;
        }
    }
}
