using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_BTT // BuTton Type - sent back when user types into a text entry button
    {
        private byte Size;		// 104
        private PacketTypeEnum Type;		// ISP_BTT
        public byte ReqI;		// ReqI as received in the IS_BTN
        public byte UCID;		// connection that typed into the button (zero if local)

        public byte ClickID;	// button identifier originally sent in IS_BTN
        public byte Inst;		// used internally by InSim
        public byte TypeIn;		// from original button specification
        private byte Sp3;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 96)]
        string Text;	// typed text, zero to TypeIn specified in IS_BTN

        public IS_BTT()
        {
            Size = 104;
            Type = PacketTypeEnum.ISP_BTT;
            Sp3 = 0;
        }
    }
}
