using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_BTN // BuTtoN - button header - followed by 0 to 240 stringacters
    {
        #region Member

        private byte size;		// 12 + TEXT_SIZE (a multiple of 4)
        private PacketTypeEnum type;		// ISP_BTN
        private byte reqI;		// non-zero (returned in IS_BTC and IS_BTT packets)
        private byte uCID;		// connection to display the button (0 = local / 255 = all)

        private byte clickID;	// button ID (0 to 239)
        private byte inst;		// used internally by InSim
        private ButtonStyleFlagsEnum bStyle;		// button style flags - see below
        private byte typeIn;		// max strings to type in - see below

        private byte l;			// left   : 0 - 200
        private byte t;			// top    : 0 - 200
        private byte w;			// width  : 0 - 200
        private byte h;			// height : 0 - 200

        //TODO: Variable Size
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 240)]
        private string text; // 0 to 240 stringacters of text

        #endregion

        #region Properties

        public Byte ReqI
        {
            get
            {
                return reqI;
            }
            set
            {
                reqI = value;
            }
        }

        public Byte UCID
        {
            get
            {
                return uCID;
            }
            set
            {
                uCID = value;
            }
        }

        public Byte ClickID
        {
            get
            {
                return clickID;
            }
            set
            {
                clickID = value;
            }
        }

        public Byte Inst
        {
            get
            {
                return inst;
            }
            set
            {
                inst = value;
            }
        }

        public ButtonStyleFlagsEnum BStyle
        {
            get
            {
                return bStyle;
            }
            set
            {
                bStyle = value;
            }
        }

        public Byte TypeIn
        {
            get
            {
                return typeIn;
            }
            set
            {
                typeIn = value;
            }
        }

        public Byte L
        {
            get
            {
                return l;
            }
            set
            {
                l = value;
            }
        }

        public Byte T
        {
            get
            {
                return t;
            }
            set
            {
                t = value;
            }
        }

        public Byte W
        {
            get
            {
                return w;
            }
            set
            {
                w = value;
            }
        }

        public Byte H
        {
            get
            {
                return h;
            }
            set
            {
                h = value;
            }
        }

        public string Text
        {
            get
            {
                return text;
            }
            set
            {
                text = value;
            }
        }
        
        #endregion

        #region Constructor

        public IS_BTN()
        {
            size = 252;
            type = PacketTypeEnum.ISP_BTN;
        }

        #endregion
    }
}
