using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_BFN // Button FunctioN - delete buttons / receive button requests
    {
        #region Member

        private byte size;		// 8
        private PacketTypeEnum type;		// ISP_BFN
        private byte reqI;		// 0
        private IS_BFNTypeEnum subT;		// subtype, from BFN_ enumeration (see below)

        private byte uCID;		// connection to send to or from (0 = local / 255 = all)
        private byte clickID;	// ID of button to delete (if SubT is BFN_DEL_BTN)
        private byte inst;		// used internally by InSim
        private byte sp3;

        #endregion

        #region Properties

        public IS_BFNTypeEnum SubT
        {
            get
            {
                return subT;
            }
            set
            {
                subT = value;
            }
        }

        public Byte UCID
        {
            get
            {
                return uCID;
            }
            set
            {
                uCID = value;
            }
        }

        public Byte ClickID
        {
            get
            {
                return clickID;
            }
            set
            {
                clickID = value;
            }
        }

        public Byte Inst
        {
            get
            {
                return inst;
            }
            set
            {
                inst = value;
            }
        }

        #endregion

        #region Constructor

        public IS_BFN()
        {
            size = 8;
            type = PacketTypeEnum.ISP_BFN;
            reqI = 0;

            sp3 = 0;
        }

        #endregion
    }
}
