/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/
#include "version.h"
#include "ilua.h"
#include "insim.h"
#include "events.h"
#include "miscfuncs.h"
#include "config.h"

lua_State* L = NULL;
struct insim_t *I = NULL;

int main (int argc, char *argv[])
{
    printf("LuaLFS v%s\nPowered By %s\n\n", VERSION, LUA_VERSION);
	L = ilua_init();
	ilua_load(L);
	printf("\n");

    I = insim_create();
    if (I == NULL)
    {
        fprintf(stderr, "insim_create: Could not be created.\n");
        return -1;
    }

    load_conf(I, L);

    printf("\n");

    do
    {

        int ccounter = 0;
        int coutput = -1;

        do
        {
            coutput = insim_connect(I);
            if (coutput == 0)
                break;
            ++ccounter;

            LSLEEP(I->socket.select_timeout.tv_sec);
        } while ((ccounter < I->internals.connection_attempts) && (!I->internals.reconnect));

        if (coutput < 0)
        {
            fprintf(stderr, "insim_connect: could not connect after %d attempts.\n", I->internals.connection_attempts);
            continue;
        }

        printf("Connected\n");

        while ((!I->internals.quit) && (insim_recv(I) > 0))
            ;

        ilua_evt_fire(L, EVT_DISCONNECTED, NULL, 0);
        insim_disconnect(I);
        printf("Disconnected\n");

    } while ((!I->internals.quit) && (I->internals.reconnect));

    insim_destroy(I);
    ilua_close(L);

	return 0;
}
