srv = {
	connections = { number = 0, },
	racers = { number = 0, }
}

function srv_init()
	luaLFS:mst("luaLFS v"..luaLFS_VERSION.." active.")
end

function srv_disconnect()
	print("Disconnecting server api")
	srv = nil
end

function srv_newconn(imsg)
	local t = luaLFS:ncn(imsg)
	local topic = string.gsub(config.srv.welcome, "$p", luaLFS:stripctrlchars(t.pname))
	local rules = string.gsub(config.srv.rules, "$p", luaLFS:stripctrlchars(t.pname))
	srv.connections.number = t.total-1

	print(os.date('%x %X').." : Player joined ("..t.uname.."). "..srv.connections.number.." in server.")
	
	t.fakeadmin = 0
	for i,v in ipairs(config.srv.admins) do 
		if (v == t.uname) then
			t.fakeadmin = 1
		end
	end

	luaLFS:mtc(t.ucid, 0, topic)

	if (t.admin == 1) then
		luaLFS:mtc(t.ucid, 0, ":You have real admin rights")
	end

	if (t.fakeadmin == 1) then
		luaLFS:mtc(t.ucid, 0, ":You have pseudo-admin rights")
	end

	luaLFS:mtc(t.ucid, 0, rules)

	table.insert(srv.connections, t.ucid, t)
end

function srv_connleave(imsg)
	local t = luaLFS:cnl(imsg)
	srv.connections.number = t.total-1
	print(os.date('%x %X').." : Player left ("..srv.connections[t.ucid].uname.."). "..srv.connections.number.." in server.")

	if (srv.connections[t.ucid] ~= nil) then
		table.remove(srv.connections, t.ucid)
	end
end

function srv_antivote(imsg)
	local t = luaLFS:vtn(imsg)
	if ((t.action == VOTE_RESTART) and ((srv.connections[t.ucid] == nil) or (srv.connections[t.ucid].admin < 1))) then
		luaLFS:mtc(t.ucid, 0, "No restarts at this time")
		luaLFS:vtc()
	end
end

function srv_magicwords(imsg)
	local t = luaLFS:mso(imsg)
	if (luaLFS.versions.product ~= "DEMO") then
		local said = luaLFS:stripctrlchars(string.match(t.msg, "[%w%s%p]+ : (.+)"))
		if ((srv.connections[t.ucid] ~= nil) and ((srv.connections[t.ucid].fakeadmin > 0) or (srv.connections[t.ucid].admin > 0))) then
			if (said == config.LFS.prefix.."restart") then
				luaLFS:mst("/restart")
			elseif (said == config.LFS.prefix.."qualify") then
				luaLFS:mst("/qualify")
			elseif (said == config.LFS.prefix.."quit") then
				luaLFS_quit()
			end
		end
	else
		luaLFS:mtc(t.ucid, 0, "Magic words isn't designed for DEMO mode. Sorry.")
	end
end


function byebye(imsg)
	local o = luaLFS:iii(imsg)
	if ((srv.connections[o.ucid] ~= nil) and ((srv.connections[o.ucid].admin > 0) or (srv.connections[o.ucid].fakeadmin > 0))) then
		if (o.msg == config.LFS.prefix.."quit") then
			luaLFSapi:mst("luaLFS leaving.")
			luaLFS_quit()
		elseif (o.msg == config.LFS.prefix.."rehash") then
			luaLFSapi:mst("luaLFS rehashing.")
			luaLFS_rehash()
		end
	end
end

evt_bind(ISP_III, byebye)

evt_bind(EVT_CONNECTED, srv_init)
evt_bind(EVT_DISCONNECTED, srv_disconnect)

evt_bind(ISP_NCN, srv_newconn)
evt_bind(ISP_CNL, srv_connleave)

evt_bind(ISP_MSO, srv_magicwords)

--evt_bind(ISP_VTN, srv_antivote)
