config =
{
	--- Configuration for luaLFS
	luaLFS = 
	{
		-- Auto reconnect
		-- This is a VERY dangerous setting. It effectively puts luaLFS
		-- into a recursive loop, trying to connect FOREVER. 
		-- If set it overrides connection_attempts
		-- It is HIGHLY recommended that it remains set to 0, except for servers
		-- Use at your own risk
		auto_reconnect = 0,
		-- Number of times luaLFS attempts to connect to LFS - overridden 
		-- if auto_reconnect is set
		connection_attempts = 5,
		-- ADVANCED
		-- Keepalive
		keepalive = 30,
		-- polling is the amount of time between select() timeouts
		-- also used for the amount of time between connection attempts
		polling = 5, 
		-- Minimum timeout in seconds before we assume LFS has been closed,
		timeout = 70,
		-- verbosity of luaLFS
		verbose = 0,
	},
	--- Configuration for LFS
	LFS = 
	{
		-- The address of computer running LFS
		address = "localhost",
		-- The port LFS is listening for InSim connections on
		port = 29999,
		-- The administrative password
		password = "test",
		-- Number of seconds between NLP or MCI packets (0=none)
		nodesecs = 0, 
		-- Flags
		-- XXX: Not yet implemented
		flags = 0,
		-- Character to prefix all messaged destined specifically for the host
		prefix = "!",
	},
	--- Configuration for example server module
	srv = 
	{
		-- Welcome banner
		welcome = ":Welcome $p!",
		-- Rules banner
		rules = ":Expect instability and unusual features",
		-- Fake administrators - by username
		admins = { "the_angry_angel", },
	},
}
