function srv_init()
	luaLFS:mst("luaLFS v"..luaLFS_VERSION.." active.")
end

evt_bind(EVT_CONNECTED, srv_init)

function srv_newconn(imsg)
	local t = luaLFS:ncn(imsg)
	splayer = t.playername
	topic = string.gsub("Welcome $p. Play nicely.", "$p", luaLFS:stripctrlchars(splayer))

	rules = config.srv.rules
	luaLFS:mtc(t.connection, 0, topic)
	if (t.admin == 1) then
		luaLFS:mtc(t.connection, 0, "You have real admin rights")
	end

	for k, v in pairs(config.srv.admins) do
		if (string.match(v, t.username) ~= nil) then
			luaLFS:mtc(t.connection, 0, "You have proxy rights")
			break
		end
	end
	luaLFS:mtc(t.connection, 0, rules)
end

evt_bind("NCN", srv_newconn)
