srv = {
	connections = { },
}

function srv_init()
	luaLFS:mst("luaLFS v"..luaLFS_VERSION.." active.")
end

function srv_newconn(imsg)
	local t = luaLFS:ncn(imsg)
	splayer = t.playername
	topic = string.gsub(config.srv.welcome, "$p", luaLFS:stripctrlchars(splayer))

	rules = config.srv.rules
	luaLFS:mtc(t.connection, 0, topic)
	if (t.admin == 1) then
		luaLFS:mtc(t.connection, 0, "You have real admin rights")
	end

	t.fakeadmin = 0

	for k, v in pairs(config.srv.admins) do
		if (string.match(v, t.username) ~= nil) then
			luaLFS:mtc(t.connection, 0, "You have proxy rights")
			t.fakeadmin = 1
			break
		end
	end
	luaLFS:mtc(t.connection, 0, rules)

	table.insert(srv.connections, t.connection, t)
end

function srv_antivote(imsg)
	local t = luaLFS:vtn(imsg)
	if ((t.action == luaLFS.vote.restart) and (srv.connections[t.connection].admin < 1)) then
		luaLFS:mtc(t.connection, 0, "Race control: No restarts at this time ")
		luaLFS:vtc()
	end
end

function srv_magicwords(imsg)
	local t = luaLFS:mso(imsg)
	local who = string.match(t, "([%w%s%p]+) :")
	local said = luaLFS:stripctrlchars(string.match(t, "[%w%s%p]+ : (.+)"))
	if (who ~= nil) then
		for k, v in ipairs(srv.connections) do
			if ((who == luaLFS:stripctrlchars(v.playername)) and (v.fakeadmin > 0)) then
				if (said == config.srv.cmd_prefix.."restart") then
					luaLFS:mst("/restart")
				elseif (said == config.srv.cmd_prefix.."qualify") then
					luaLFS:mst("/qualify")
				end
			end
		end
	end
end

evt_bind(EVT_CONNECTED, srv_init)
evt_bind("NCN", srv_newconn)
evt_bind("VTN", srv_antivote)
evt_bind("MSO", srv_magicwords)
