luaLFS_VERSION_API = 0.1

print("Loading API v"..luaLFS_VERSION_API)

luaLFSapi = {}
luaLFSapi.__index = luaLFSapi

function luaLFSapi.create()
	l = {}
	setmetatable(l, luaLFSapi)
	l.versions = { api = luaLFS_VERSION_API, insim = 0, lfs = nil, product = nil, }
	return l
end

function luaLFSapi:version()
	return self.versions
end

--- Misc
-- IS_TINY
function luaLFSapi:tiny(reqi, subt)
	local omsg = bpack("bbbb", 4, ISP_TINY, reqi, subt)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

-- IS_SMALL
function luaLFSapi:small(reqi, subt, uval)
	local omsg = bpack("bbbbI", 8, IS_SMALL, reqi, subt, uval)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

-- Strip chars
-- ^L = Latin 1
-- ^G = Greek
-- ^C = Cyrillic
-- ^J = Japanese
-- ^E = Central Europe
-- ^T = Turkish
-- ^B = Baltic
-- ^0-9
function luaLFSapi:stripctrlchars(imsg)
	return string.gsub(imsg, "%^[%L%G%C%J%E%T%B%d]", "")
end

--- Version
function luaLFSapi:ver(imsg)
	local n, psize, pty, reqi, spare, version, product, insimver = bunpack(imsg, "bbbbA8A6H")
	return { version = version, product = product, insimver = insimver }
end

--- State pack

--- Screen Mode
function luaLFSapi:mod(sixteenbit, refresh, width, height)
	local omsg = bpack("bbbbiiii", 20, IS_MOD, 0, 0, sixteenbit, refresh, width, height)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

--- Messaging
function luaLFSapi:mso(imsg)
	-- UPDATED
	local n, psize, pty, reqi, spare, ucid, plid, user, textstart, msg = bunpack(imsg, "bbbbbbbbz")
	return { ucid = ucid, plid = plid, user = user, textstart = textstart, msg = msg }
end

function luaLFSapi:iii(imsg)
	-- NEW
	local n, psize, pty, reqi, spare, ucid, plid, spare2, spare3, msg = bunpack(imsg, "bbbbbbbbz")
	return { ucid = ucid, plid = plid, msg = msg}
end

function luaLFSapi:mst(imsg)
	-- UPDATED
	-- XXX: Add multi-packet support for msgs longer than 63 bytes (last byte is always \0)
	local omsg = bpack("bbbbz", 68, ISP_MST, 0, 0, imsg..string.rep("\0", 63 - string.len(imsg)))
	luaLFS_sendmsg(omsg, string.len(omsg))
end

function luaLFSapi:mtc(ucid, plid, msg)
	-- UPDATED
-- XXX: Add multi-packet support for msgs longer than 63 bytes (last byte is always \0)
	local omsg = bpack("bbbbbbbbz", 72, ISP_MTC, 0, 0, ucid, plid, 0, 0, msg..string.rep("\0", 63 - string.len(msg)))
	luaLFS_sendmsg(omsg, string.len(omsg))
end

function luaLFSapi:sch(char, flags)
	-- UPDATED
	local omsg = bpack("bbbbbbbb", 8, ISP_SCH, 0, 0, string.byte(char), flags, 0, 0)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

--- Multiplayer
function luaLFSapi:ism(imsg)
	-- UPDATED
	local n, psize, pty, reqi, spare, ishost, spare1, spare2, spare3, hostname = bunpack(imsg, "bbbbbbbbz")
	return { host = ishost, hname = hostname }
end

--- Voting
-- A vote has started
function luaLFSapi:vtn(imsg)
	-- UPDATED
	local n, psize, pty, requ, spare, ucid, action, spare2, spare3 = bunpack(imsg, "bbbbbbbb")
	return { ucid = ucid, action = action }
end

-- Send a vote cancel
function luaLFSapi:vtc()
	-- UPDATED
	self:tiny(0, TINY_VTC)
end

-- Vote outcome
-- Subscribe to a IS_SMALL and it will return non-nil values if it was a completed vote action
function luaLFSapi:vta(imsg)
	-- UPDATED
	local n, psize, pty, reqi, subt, uval1 = bunpack(imsg, "bbbbI")
	print("Subt: "..subt)
	print("UVal: "..uval1.." "..SMALL_VTA)
	if (uval == SMALL_VTA) then
		print("It was a VTA!")
		return uval
	else
		return nil
	end
end

--- Race Tracking
-- XXX: Needs to be finished

function luaLFSapi:ncn(imsg)
	-- UPDATED
	local n, psize, pty, reqi, ucid, unameU, pnameU, admin, total = bunpack(imsg, "bbbbA24A24bbbb")
	local n, uname = bunpack(unameU, "z")
	local n, pname = bunpack(pnameU, "z")
	return { ucid = ucid, uname = uname, pname = pname, admin = admin, total = total}
end

function luaLFSapi:cnl(imsg)
	-- UPDATED
	local n, psize, pty, reqi, ucid, spare, total, spare2, spare3 = bunpack(imsg, "bbbbbbbb")
	return { ucid = ucid, total = total}
end

--- Non-verified Race Tracking
-- XXX: Needs to be finished

--- In-game Camera Control
-- XXX: Needs to be finished

-- Set Car Camera
-- XXX: Needs to be finished
function luaLFSapi:scc(racer_position_to_view, ingamecam, uniqueid)
	omsg = bpack("zbbbb", "SCC", racer_position_to_view, uniqueid, 0)
	sendmsg(omsg, string.len(omsg))
end

luaLFS = luaLFSapi.create()

function recv_version(imsg)
	local n = nil
	local t = luaLFS:ver(imsg)
	luaLFS.versions.insim = t.insimver
	n, luaLFS.versions.lfs = bunpack(t.version, "z")
	n, luaLFS.versions.product = bunpack(t.product, "z")
	print("LFS "..luaLFS.versions.lfs.." running in "..luaLFS.versions.product.." mode, using InSim v"..luaLFS.versions.insim)
end

evt_bind(ISP_VER, recv_version)
