using System;
using JanezCufer;

namespace Tester
{
    class Program
    {
        InSimClient.InSimClient c;

        static void Main(string[] args)
        {
            new Program(args);
        }

        public Program(string[] args)
        {
            int InSimPort = 29999;
            string host = "127.0.0.1";
            string adminPass = "Pass";

            ArgumentParser argParser = new ArgumentParser(args);
            if (argParser.HasOption("insim"))
                InSimPort = int.Parse(argParser.GetOption("insim"));
            if (argParser.HasOption("host"))
                host = argParser.GetOption("host");
            if (argParser.HasOption("pass"))
                adminPass = argParser.GetOption("pass");

            c = new InSimClient.InSimClient(host, adminPass, InSimPort, 0, 0);
            
            c.Start();
            //c.RefreshConnections();

            c.PlayerChangedAids += new InSimClient.InSimClient.InSimEventDelegate(PlayerChangedAids);
            c.PlayerChangedCameraView += new InSimClient.InSimClient.InSimEventDelegate(c_PlayerChangedCameraView);

            System.Console.ReadLine();

            c.Stop();
        }

        void c_PlayerChangedCameraView(object sender, InSimClient.Player p)
        {
            System.Diagnostics.Debug.Write(".");
            if (p.LastView != InSimClient.ViewEnum.Driver)
            {
                c.Send("/msg " + p.Username + "^1 spectated for using non-cockpit view!");
                c.Send("/spectate " + p.Username);
            }
        }

        void PlayerChangedAids(object sender, InSimClient.Player p)
        {
            //InSimClient.InSimClient c = (InSimClient.InSimClient)sender;

            if (p.IsUsingBrakeHelp |
                p.IsUsingAutoClutch |
                p.IsUsingAutoGears |
                p.IsUsingThrottleBlipOnGearChange |
                p.IsUsingThrottleCutOnGearChange
            )
            {
                c.Send("/msg " + p.Username + "^1 spectated for using help!");
                c.Send("/spectate " + p.Username);
            }
                        
        }
    }
}
