using System;
using System.Text;

namespace JanezCufer
{
    public class ArgumentParser
    {
        
        /// <summary>
        /// Standard constructor.
        /// </summary>
        /// <param name="args">Arguments from command line.</param>
        public ArgumentParser(String[] args)
        {
            for (int i = 0; i < args.Length; i++)
            {
                if (args[i].StartsWith("-") || args[i].StartsWith("/"))
                {
                    int loc = args[i].IndexOf("=");
                    String key = (loc > 0) ? args[i].Substring(1, loc-1) : args[i].Substring(1);
                    String value = (loc > 0) ? args[i].Substring(loc + 1) : "";
                    options.Add(key.ToLower(), value);
                }
                else
                    pars.Add(args[i]);
            }
        }

        /// <summary>
        /// Returns indication if specified optional parameter is present.
        /// </summary>
        /// <param name="opt">Optional parameter.</param>
        /// <returns>True if specified optional parameters is present.</returns>
        public bool HasOption(String opt)
        {
            return options.ContainsKey(opt.ToLower());
        }

        /// <summary>
        /// Returns value of an option.
        /// </summary>
        /// <param name="opt">Optional parameter.</param>
        /// <returns>Value of specified optional parameter</returns>
        public String GetOption(String opt)
        {
            return (String)options[opt.ToLower()];
        }

        /// <summary>
        /// Retrieves list of non-optional arguments.
        /// </summary>
        public string[] Arguments
        {
            get
            {
                return (string[])pars.ToArray(typeof(string));
            }
        }

        private System.Collections.ArrayList pars = new System.Collections.ArrayList();
        private System.Collections.Hashtable options = new System.Collections.Hashtable();
    }
}
