/* SkinsX Directory Cleaner (amp88, v0.1) */

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Scanner;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SkinsXCleaner
{
	static String skinsXDirPath="";
	static File[] skinsXFiles;
	
	public static void main(String[] args)
	{
		loadConfig();
		checkSkinsXDir();
		saveConfig();
		showDeletionOptions();
	}
	
	public static void loadConfig()
	{
		try
		{
			File configFile = new File("config");
			FileReader fileReader = new FileReader(configFile);
			BufferedReader bufReader = new BufferedReader(fileReader);
			String inputLine = bufReader.readLine();
			
			while(inputLine != null)
			{
				skinsXDirPath = inputLine;
				inputLine = bufReader.readLine();
			}
		}
		catch(FileNotFoundException fnfe)
		{
			// Config file doesn't exist
		}
		catch(Exception e)
		{
			System.out.println("Exception (loadConfig): "+e.getMessage());
		}
	}
	
	public static void checkSkinsXDir()
	{
		if(skinsXDirPath.compareTo("") == 0)
		{
			JFrame frame = new JFrame();
			
			JOptionPane.showMessageDialog(frame, "Please choose the location of your"
					+" skins_x\nfolder from from the next window.");
			
			System.out.println("");
			
			JFileChooser skinsXChooser = new JFileChooser();
			skinsXChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			skinsXChooser.showOpenDialog(frame);
			
			try
			{
				File chosenFile = skinsXChooser.getSelectedFile();
				skinsXDirPath = chosenFile.getAbsolutePath();
				
				while(chosenFile.getName().compareToIgnoreCase("skins_x") != 0)
				{
					System.out.println("The folder you have chosen does not appear to be "
							+"your skins_x folder. Please try again.");
					
					int option = JOptionPane.showConfirmDialog(frame, "The folder you have chosen does"+
							" not appear to\nbe your skins_x folder. Please try again.", 
							"Folder Error", JOptionPane.OK_CANCEL_OPTION);
					
					// User pressed cancel button
					if(option == 2)
					{
						System.out.println("User cancels, system exiting");
						frame.dispose();
						System.exit(0);
					}
					
					skinsXChooser.showOpenDialog(frame);
					chosenFile = skinsXChooser.getSelectedFile();
					skinsXDirPath = chosenFile.getAbsolutePath();
				}
			}
			catch(NullPointerException npe)
			{
				System.out.println("Exception (checkSkinsXDir): No File Selected, "+
																  npe.getMessage());
			}
		}
	}
	
	public static void showDeletionOptions()
	{
		try
		{
			File skinsXDir = new File(skinsXDirPath);
			skinsXFiles = skinsXDir.listFiles();
			long totalFilesize=0, beforeFilesize;
			
			for(int i=0; i<skinsXFiles.length; i++)
			{
				totalFilesize += skinsXFiles[i].length();
			}
			
			beforeFilesize = totalFilesize;
			
			System.out.println("Your LFS skins_x folder is located at \""+skinsXDirPath+"\"");
			System.out.println("It currently contains "+skinsXFiles.length+" files totalling "
								   +roundNumber((totalFilesize/1048576.0), 2)+" megabytes\n");
			
			System.out.println("Select how you would like to clean it from the list below:");
			
			showDeletionMenu();
			
			totalFilesize = 0;
			
			skinsXFiles = skinsXDir.listFiles();
			
			for(int i=0; i<skinsXFiles.length; i++)
			{
				totalFilesize += skinsXFiles[i].length();
			}
			
			if(beforeFilesize != totalFilesize)
			{
				System.out.println("\nYour skins_x folder now contains "+skinsXFiles.length+
					" files totalling "+roundNumber((totalFilesize/1048576.0), 2)+
					" megabytes");
				System.out.println("You have deleted "+roundNumber((beforeFilesize-totalFilesize)/
						1048576.0, 2)+" megabytes of files");
			}
			
			System.out.println("\n\nProgram has run to completion and will now exit.");
			System.exit(0);
		}
		catch(Exception e)
		{
			System.out.println("Exception (showDeletionOptions): "+e.getMessage());
		}
	}
	
	public static void saveConfig()
	{
		try
		{
			File outputFile = new File("config");
	    	FileOutputStream outFileStream = new FileOutputStream(outputFile);
	    	PrintWriter outStream = new PrintWriter(outFileStream);
	    	
	    	if(skinsXDirPath.compareTo("") != 0)
	    		outStream.println(skinsXDirPath);
	    	
	    	outStream.close();
		}
		catch(Exception e)
		{
			System.out.println("Exception (saveConfig): "+e.getMessage());
		}
	}
	
	public static BigDecimal roundNumber(double input, int places)
	{
		BigDecimal d1 = new BigDecimal(input);
		return d1.setScale(places, BigDecimal.ROUND_HALF_EVEN);
	}
	
	public static void showDeletionMenu()
	{
		System.out.println(" 1. Delete ALL JPEG files.");
		System.out.println(" 2. Delete JPEG files older than 30 days.");
		System.out.println(" 3. Delete JPEG files older than 1 year.");
		System.out.println(" 4. Delete JPEG files older than a specified period.");
		System.out.println(" 5. Delete all JPEG files smaller than 50 kilobytes.");
		System.out.println(" 6. Delete all JPEG files bigger than 200 kilobytes.");
		System.out.println(" 7. Delete all 512 pixel car skin files.");
		
		System.out.print("\nInput: ");
		
		Scanner sc = new Scanner(System.in);
		String inputLine = sc.nextLine();
		int userChoice = getChoice(inputLine);
		
		while(userChoice == 0)
		{
			System.out.println("You must enter a number shown in the list above.");
			inputLine = sc.nextLine();
			userChoice = getChoice(inputLine);
		}
		
		switch(userChoice)
		{
			case 1:
			{
				// All jpg files
				
				System.out.print("\nAre you sure you wish to delete ALL JPEG files? (Y/N): ");
				inputLine = sc.nextLine();
				
				if(inputLine.compareToIgnoreCase("Y") == 0)
				{
					for(int i=0; i<skinsXFiles.length; i++)
					{
						String filename = skinsXFiles[i].getName();
						
						if(filename.indexOf("jpg") != -1)
						{
							if(!skinsXFiles[i].delete())
								System.out.println(skinsXFiles[i].getName()+
										" could not be deleted.");
						}
					}
				}

				break;
			}
			case 2:
			{
				// All jpg files older than 30 days
				
				System.out.print("\nAre you sure you wish to delete JPEG files older than"+
						" 30 days? (Y/N): ");
				inputLine = sc.nextLine();
				
				if(inputLine.compareToIgnoreCase("Y") == 0)
				{
					long targetTime = System.currentTimeMillis()-(30l * 24l * 60l * 60l * 1000l);
					
					for(int i=0; i<skinsXFiles.length; i++)
					{
						String filename = skinsXFiles[i].getName();
						
						if(filename.indexOf("jpg") != -1)
						{
							if(skinsXFiles[i].lastModified() < targetTime)
							{
								if(!skinsXFiles[i].delete())
									System.out.println(skinsXFiles[i].getName()+
											" could not be deleted.");
							}
						}
					}
				}
				
				break;
			}
			case 3:
			{
				// All jpg files older than 365 days
			
				System.out.print("\nAre you sure you wish to delete JPEG files older than"+
						" 1 year? (Y/N): ");
				inputLine = sc.nextLine();
				
				if(inputLine.compareToIgnoreCase("Y") == 0)
				{
					long targetTime = System.currentTimeMillis()-(365l * 24l * 60l * 60l * 1000l);
					
					for(int i=0; i<skinsXFiles.length; i++)
					{
						String filename = skinsXFiles[i].getName();
						
						if(filename.indexOf("jpg") != -1)
						{
							if(skinsXFiles[i].lastModified() < targetTime)
							{
								if(!skinsXFiles[i].delete())
									System.out.println(skinsXFiles[i].getName()+
											" could not be deleted.");
							}
						}
					}
				}
				
				break;
			}
			case 4:
			{
				// All files older than specified period
				
				System.out.print("Delete files older than how many days? Input: ");
				inputLine = sc.nextLine();
				
				int olderThan = 0;
				
				try
				{
					olderThan = Integer.parseInt(inputLine);
				}
				catch(NumberFormatException nfe)
				{
					System.out.println("Exception parsing input value "+inputLine+
							". You must enter a number next time.");
					System.exit(0);
				}
				
				long targetTime = System.currentTimeMillis() - 
										((long) olderThan * 24l * 60l * 60l * 1000l);
				
				for(int i=0; i<skinsXFiles.length; i++)
				{
					String filename = skinsXFiles[i].getName();
					
					if(filename.indexOf("jpg") != -1)
					{
						if(skinsXFiles[i].lastModified() < targetTime)
						{
							if(!skinsXFiles[i].delete())
								System.out.println(skinsXFiles[i].getName()+
										" could not be deleted.");
						}
					}
				}
				
				break;
			}
			case 5:
			{
				// All jpeg files smaller than 50 kilobytes
				
				System.out.print("\nAre you sure you wish to delete JPEG files smaller than"+
				" 50 kilobytes? (Y/N): ");
				inputLine = sc.nextLine();
				
				if(inputLine.compareToIgnoreCase("Y") == 0)
				{
					int targetSize = 50 * 1024;
					
					for(int i=0; i<skinsXFiles.length; i++)
					{
						String filename = skinsXFiles[i].getName();
						
						if(filename.indexOf("jpg") != -1)
						{
							if(skinsXFiles[i].length() < targetSize)
							{
								if(!skinsXFiles[i].delete())
									System.out.println(skinsXFiles[i].getName()+
											" could not be deleted.");
							}
						}
					}
				}
				
				break;
			}
			case 6:
			{
				// All jpeg files bigger than 200 kilobytes
				
				System.out.print("\nAre you sure you wish to delete JPEG files bigger than"+
				" 200 kilobytes? (Y/N): ");
				inputLine = sc.nextLine();
				
				if(inputLine.compareToIgnoreCase("Y") == 0)
				{
					int targetSize = 200 * 1024;
					
					for(int i=0; i<skinsXFiles.length; i++)
					{
						String filename = skinsXFiles[i].getName();
						
						if(filename.indexOf("jpg") != -1)
						{
							if(skinsXFiles[i].length() > targetSize)
							{
								if(!skinsXFiles[i].delete())
									System.out.println(skinsXFiles[i].getName()+
											" could not be deleted.");
							}
						}
					}
				}
				
				break;
			}
			case 7:
			{
				// All 512 pixel car skins
				
				System.out.print("\nAre you sure you wish to delete 512 pixel car skins?"
						+" (Y/N): ");
				inputLine = sc.nextLine();
				
				if(inputLine.compareToIgnoreCase("Y") == 0)
				{
					int shortInt=0;
					
					for(int i=0; i<skinsXFiles.length; i++)
					{
						String filename = skinsXFiles[i].getName();
						
						if(filename.indexOf("jpg") != -1 && 
								filename.substring(0, 3).compareTo("HEL") != 0)
						{
							try
							{
								DataInputStream dis = new DataInputStream(new FileInputStream(skinsXFiles[i]));
								int height=0, width=0;
								
								for(int j=0; j<114; j++)
								{
									shortInt = dis.readUnsignedShort();
									
									if(j == 112)
										height = shortInt;
									
									if(j == 113)
									{
										width = shortInt;
									}
								}

								if(height == 512 && width == 512)
								{
									if(!skinsXFiles[i].delete())
										System.out.println(skinsXFiles[i].getName()+
												" could not be deleted.");
								}
							}
							catch(Exception e)
							{
								System.out.println("Exception (showDeletionMenu): "+
										e.getMessage());
							}
						}
					}
				}
				
				break;
			}
			default:
			{
				System.out.println("You must choose an option from the available list.");
				break;
			}
		}
	}
	
	public static int getChoice(String input)
	{
		int choice;
		
		try
		{
			choice = Integer.parseInt(input);
		}
		catch(NumberFormatException nfe)
		{
			choice = 0;
		}
		
		return choice;
	}
}
