
#include <windows.h>


// we do not take care of the type of the pointer
#define IDirect3D8 void


HINSTANCE g_hNextDll;
void LoadNextDll(void);


BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			g_hNextDll = NULL;
			break;

		case DLL_PROCESS_DETACH:
			if (g_hNextDll)
			{
				FreeLibrary(g_hNextDll);
				g_hNextDll = NULL;
			}
			break;
	}

	return TRUE;
}


// Exported function (export declared in the .def file)
IDirect3D8* WINAPI Direct3DCreate8(UINT SDKVersion)
{
	if (!g_hNextDll) LoadNextDll();

	// Hooking IDirect3D Object from Original Library
	typedef IDirect3D8 *(WINAPI* D3D8_Type)(UINT SDKVersion);
	D3D8_Type D3DCreate8_fn = (D3D8_Type)GetProcAddress(g_hNextDll, "Direct3DCreate8");
	if (!D3DCreate8_fn)
	{
		ExitProcess(0); // exit the hard way
	}

	return D3DCreate8_fn(SDKVersion);
}


void LoadNextDll(void)
{
	char path2dll[MAX_PATH];
	char path2ini[MAX_PATH];

	if (GetModuleFileName(NULL, path2ini, sizeof(path2ini)))
	{
		// get the path of the LFS folder
		while ((path2ini[strlen(path2ini) - 1] != '\\') && (strlen(path2ini) > 0))
			path2ini[strlen(path2ini) - 1] = 0;

		strcat(path2ini, "D3D8.ini");
		GetPrivateProfileString("D3D8Wrapper", "ProxyDll", "",
		                        path2dll, sizeof(path2dll), path2ini);

		if (strlen(path2dll) > 0)
		{
			g_hNextDll = LoadLibrary(path2dll);
			if (g_hNextDll)
				return;
		}
	}

	// no ini file there or loading the custom dll failed, so let's load the systems d3d8.dll

	GetSystemDirectory(path2dll, MAX_PATH);
	strcat(path2dll, "\\d3d8.dll");
	g_hNextDll = LoadLibrary(path2dll);

	if (!g_hNextDll)
	{
		ExitProcess(0); // exit the hard way
	}
}
