//  
//  TokenParse.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.


using System;
using System.Collections.Generic;
using System.Text;

namespace GLScript
{
    public class TokenParse
    {
        TokenBuffer tokenParse;
        public int curPos;
        int endPos;
		int lastLine = 0;
        public TokenParse(TokenBuffer tklist)
        {
            curPos = -1;
            endPos = tklist.TokenList.Count - 1;
            tokenParse = tklist;
        }
        public TokenParse(TokenBuffer tklist, int start, int end)
        {
            if (start != -1)
                curPos = start - 1;
            else
                curPos = -1;
            if (end != -1)
                endPos = end;
            else
                endPos = tklist.TokenList.Count - 1;
            tokenParse = tklist;
        }
        public token readNextToken()
        {
            curPos++;
			if (curPos > endPos)
				return new token(Scanner.E_END, "", lastLine+1, "E_END");
			else
			{
				lastLine = (tokenParse.TokenList[curPos] as token).lineNumber;
				return (token)tokenParse.TokenList[curPos];
			}
        }
        public token readCurrToken()
        {
            if (curPos > endPos)
                return new token( Scanner.E_END, "", 0, "E_END");
            else
                return (token)tokenParse.TokenList[curPos];
        }
    }
}
