/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#include "version.h"
#include "ilua.h"
#include "insim.h"
#include "events.h"
#include "config.h"

lua_State* L;
insim_t *I;

int main (int argc, char *argv[])
{
    printf("LuaLFS v%s\nPowered By %s\n\n", VERSION, LUA_VERSION);
	ilua_init();
	ilua_load();
	printf("\n");

    I = insim_create();
    if (I == NULL)
    {
        fprintf(stderr, "insim_create: Could not be created.\n");
        return -1;
    }

    load_conf(I, L);
    ilua_evt_fire(EVT_CONFIGOK, NULL, 0);
    printf("\n");

    if (insim_connect(I) < 0)
    {
        fprintf(stderr, "insim_connect: could not connect.\n");
        return -2;
    }

    while (insim_recv(I) > 0)
        ;

	ilua_evt_fire(EVT_DISCONNECTED, NULL, 0);

    insim_destroy(I);

    ilua_close();
	return 0;
}
