/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#ifndef INSIM
#define INSIM

#ifdef WIN32
#include <windows.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <fcntl.h>
#define closesocket(s) close(s)
#define SOCKET_ERROR -1
#define INVALID_SOCKET -1
#define TRUE 1
#define FALSE 0
typedef unsigned char BOOL;
typedef unsigned char byte;
#endif
#include <time.h>
#include <stdio.h>

#include "events.h"

#define INSIM_TIMEOUT 120
#define INSIM_KEEPALIVE 30
#define INSIM_KEEPALIVE_MAX 60

typedef struct
{
    /* socket */
	int socket;
	/* select FD set */
	fd_set ssets;
	/* LFS specific */
	char *listen_address;
	short listen_port;
	char *send_address;
	short send_port;
	char *admin_password;
	char flags;
	char node_secs;
	/* How long before we timeout select */
	struct timeval select_timeout;
	/* Last time we sent a keepalive to LFS */
	time_t last_keepalive;
	/* Last time LFS contacted us */
	time_t last_contact;
	/* Have we got the version from LFS yet? */
	BOOL gotversion;
	/* How long before we assume LFS has closed */
	unsigned int timeout;
	/* How long before we sent keep alives */
	unsigned int keepalive;
	/* Spam-factor */
	unsigned int verbose;

} insim_t;

insim_t *insim_create();
int insim_destroy(insim_t *I);

int insim_connect(insim_t *I);
int insim_recv(insim_t *I);
int insim_disconnect(insim_t *I);

int insim_send(insim_t *I, char *buf, int size);

int insim_init(insim_t *I);
int insim_close(insim_t *I);

#define ISF_RACE_TRACKING 1 // bit 0 : turns on race tracking
#define ISF_GUARANTEE 2 // bit 1 : turns on guaranteed delivery
#define ISF_SPLIT_MESSAGE 4 // bit 2 : use MSS, not MSO for user messages
#define ISF_NO_WARNINGS 8 // bit 3 : turns off packet warnings
#define ISF_KEEP_ALIVE 16 // bit 4 : makes lfs send keep alive packets
#define ISF_NLP_MCI 32 // bit 5 : makes lfs send MCI instead of NLP

// UDP packet to initialise the InSim system
struct ISI
{
	char id[4];	// ISI + zero
	unsigned short port; // Port for UDP replies from LFS (0...65535)
	byte flags; // Bit flags for options - see below
	byte nodesecs; // Number of seconds between NLP or MCI packets (0=none)
	char admin[16]; // Admin password (required if set in LFS host options)
};

struct ISP // General purpose 8 byte UDP packet
{
	char id[4]; // 3 character identifier followed by zero character
	int	value; // 32 bit value depending on the type of InSimPack
};

struct ISV
{
	char id[4];	// VER + zero
	char version[8]; // LFS version, e.g. 0.3G
	char product[6]; // Product : DEMO or S1
	unsigned short insimver; // InSim Version : increased when InSim packets change
};

struct SCH
{
    char id[4];
    char character;
    byte flags;
    byte sp2;
    byte sp3;
};

#endif
