/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "version.h"

#ifndef ILUA
#define ILUA

int ilua_init();
int ilua_close();
int ilua_load();

int ilua_load_core();
int ilua_load_custom();

int ilua_evt_fire(const char *type, const char *arg, size_t length);
#endif
