luaLFS_VERSION_API = 0.1

print("Loading API v"..luaLFS_VERSION_API)

luaLFSapi = {}
luaLFSapi.__index = luaLFSapi

function luaLFSapi.create()
	l = {}
	setmetatable(l, luaLFSapi)
	l.versions = { api = luaLFS_VERSION_API, insim = 0 }
	return l
end

function luaLFSapi:version()
	return self.versions
end

--- Misc

-- InSimPack
function luaLFSapi:isp(packet, value)
	omsg = bpack("zi", packet, value)
	sendmsg(omsg, string.len(omsg))
end

-- ACK
function luaLFSapi:ack()
	self:isp("ACK", 0)
end

--- Messaging

function luaLFSapi:mst(msg)
	omsg = bpack("zz", "MST", msg..string.rep("\0", 63 - string.len(msg)))
	sendmsg(omsg, string.len(omsg))
end

function luaLFSapi:mso(imsg)
	n, id, omsg = bunpack(imsg, "zz")
	return omsg
end

function luaLFSapi:sch(char)
	char = string.upper(char)
	msg = bpack("zcbbb", "SCH", string.byte(char), 0, 0, 0)
	sendmsg(msg, string.len(msg))
end

--- Multiplayer

function luaLFSapi:ism(imsg)
	n, id, host, spare1, spare2, spare3, hostname = bunpack(imsg, "zbbbbz")
	t = { host = host, hostname = hostname }
	return t
end

--- Voting

-- A vote has started
function luaLFSapi:vtn(imsg)
	n, id, connection, votetype, spare1, spare2 = bunpack(imsg, "zcccc")
	t = { connection = connection, action = votetype }
	return t
end

-- A vote action has been completed
function luaLFSapi:vta(imsg)
	n, id, action = bunpack(imsg, "zi")
	return action
end

-- Send a vote cancel
function luaLFSapi:vtc(imsg)
	self:isp("VTC", 0)
end

--- Screen Mode

-- Setting the screen mode
function luaLFSapi:mod(sixteenbit, refresh, width, height)
	omsg = bpack("ziiii", "MOD", sixteenbit, refresh, width, height)
	sendmsg(omsg, string.len(omsg))
end

--- Race Tracking
-- XXX: Needs to be finished

--- Non-verified Race Tracking
-- XXX: Needs to be finished

--- In-game Camera Control
-- XXX: Needs to be finished

-- Set Car Camera
-- XXX: Needs to be finished
function luaLFSapi:scc(racer_position_to_view, ingamecam, uniqueid)
	omsg = bpack("zbbbb", "SCC", racer_position_to_view, uniqueid, 0)
	sendmsg(omsg, string.len(omsg))
end

luaLFS = luaLFSapi.create()
