/*
WebStats v1.2 - LFSLapper WWW statistics
Copyright (C) 2006  Janez Cufer

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <string>
#include <list>
#include <iostream>
#include <fstream>
#include <map>
#include <algorithm>

int split(std::string s, char splitchar, std::list<std::string>& list)
{
	int off = 0;
	int newoff = 0;
	int counter = 0;

	do{
		std::string ns;
		
		newoff = s.find(splitchar, off);
		if(newoff != -1)
			ns = s.substr(off,newoff-off);
		else
			ns = s.substr(off);

		off = newoff+1;
		list.push_back(ns);
		counter++;
	}while(newoff != -1);

	return counter;
}

std::string replace(std::string s, std::string sub, std::string rep)
{
	if(sub.size() == 0 || s.size() == 0)
		return s;
	
	int off = 0;

	do{
		off = s.find(sub,off);
		if(off == -1)
			return s;
		
		s.replace(off,sub.size(),rep);
		off+=rep.size();
	}while(true);
}

struct Player
{
	std::string nickname;
	std::string car,time,track;
	std::string s1,s2,s3;
	int driftscore;

	std::string username;
	std::string date;
	std::string timeofdate;

	static int TimeDeserialize(std::string times)
	{
		int ticks = 0;
		int idx1 = times.find('.');
		std::string mins = times.substr(0,idx1);

		int idx2 = times.find('.',idx1+1);
		std::string secs = times.substr(idx1+1,idx2-idx1);

		std::string hun = times.substr(idx2+1);

		return 
			atol(hun.c_str())
			+ atol(secs.c_str())*100
			+ atol(mins.c_str())*100*60;
	}

	static bool greater(Player p,Player r)
	{
		if(TimeDeserialize(p.time) < TimeDeserialize(r.time))
			return true;
		else
			return false;
	}

	static bool greater_driftscore(Player p,Player r)
	{
		if(p.driftscore > r.driftscore)
			return true;
		else
			return false;
	}

	static void write_driftscore(Player p)
	{
		std::cout << "<tr>";
		std::cout << "<td>" << p.driftscore << "</td>";
		std::cout << "<td>" << p.nickname << "</td>";
		std::cout << "<td>" << p.car << "</td>"; 
		std::cout << "<td>" << p.track << "</td>";
		std::cout << "</tr>" << std::endl;
	}

	static void write(Player p)
	{
		std::cout << "<tr>";
		std::cout << "<td>" << p.time << "</td>";
		std::cout << "<td>" << p.nickname << "</td>";
		
		if(TimeDeserialize(p.s1) != 0)
			std::cout << "<td>" << p.s1 << "</td>";
		else
			std::cout << "<td></td>";

		if(TimeDeserialize(p.s2) != 0)
			std::cout << "<td>" << p.s2 << "</td>";
		else
			std::cout << "<td></td>";

		if(TimeDeserialize(p.s3) != 0)
			std::cout << "<td>" << p.s3 << "</td>";
		else
			std::cout << "<td></td>";
		
		std::cout << "<td>" << p.car << "</td>";
		std::cout << "<td>" << p.track << "</td>";
		std::cout << "</tr>" << std::endl;
	}
};

typedef std::map<std::string,Player> tPlayers;
typedef std::map<std::string,tPlayers> tCars;
typedef std::map<std::string,tCars > tTracks;

std::string NickNameToWWW(std::string s)
{
	std::string out = "<font color=\"#000000\">";
	bool IsNextSpecial = false;
	for(int i=0;i<s.size();i++)
	{
		if(IsNextSpecial)
		{
			if(s[i] == '^')
			{
				out+=s[i];
			}
			else
			{
				switch(s[i])
				{
				case '0'://black
					out+="</font><font color=\"#000000\">";
					break;

				case '1'://red
					out+="</font><font color=\"#ff0000\">";
					break;

				case '2'://green
					out+="</font><font color=\"#00ff00\">";
					break;

				case '3'://yellow
					out+="</font><font color=\"yellow\">";
					break;
	
				case '4'://blue
					out+="</font><font color=\"#0000ff\">";
					break;

				case '5'://violet
					out+="</font><font color=\"#ff00ff\">";
					break;

				case '6'://cyan
					out+="</font><font color=\"cyan\">";
					break;

				case '7'://white
					out+="</font><font color=\"#ffffff\">";
					break;

				case '8'://default
					out+="</font><font color=\"#cccccc\">";
					break;

				//skip language designations
				case 'L':case 'C':case 'E':case 'J':case 'T':case 'G':case 'B':
					break;

				default:
					out+=s[i];
					break;
				}

				IsNextSpecial = false;
			}
		}
		else
		{
			if(s[i] == '^')
				IsNextSpecial = true;
			else
				out+=s[i];
		}
	}
	return out + "</font>";
}

int ReadPBFile(std::string filename,tTracks& tracks)
{
	std::ifstream f(filename.c_str()/*,std::ios_base::in,(int)std::ios_base::_Openprot*/);

	if(f.fail())
		return 0;

	char line[128];
	f.getline(line,128);
	if(strcmp(line,"USERNAME")!=0)
		return 0;

	while(!f.eof())
	{
		Player p;

		f.getline(line,128);
		
		if(f.eof())
			break;

		p.username = line;
		f.getline(line,128);p.nickname = NickNameToWWW(line);
		
		f.getline(line,128);p.date = line;
		f.getline(line,128);p.timeofdate = line;

		f.getline(line,128);p.car = line;
		f.getline(line,128);p.time = line;
		f.getline(line,128);p.track = line;
		f.getline(line,128);p.s1 = line;
		f.getline(line,128);p.s2 = line;
		f.getline(line,128);p.s3 = line;

		tCars* carMap = &tracks[p.track];
		tPlayers* playerMap = &(*carMap)[p.car];
		(*playerMap)[p.nickname] = p;

		(*carMap)[p.car] = *playerMap;
		tracks[p.track] = *carMap;
	}

	f.close();

	return 1;
}

int ReadDriftPBFile(std::string filename,tTracks& tracks)
{
	std::ifstream f(filename.c_str()/*,std::ios_base::in,(int)std::ios_base::_Openprot*/);

	if(f.fail())
		return 0;

	char line[128];
	f.getline(line,128);
	if(strcmp(line,"USERNAME")!=0)
		return 0;

	while(!f.eof())
	{
		Player p;

		f.getline(line,128);
		
		if(f.eof())
			break;

		p.username = line;
		f.getline(line,128);p.nickname = NickNameToWWW(line);
		
		f.getline(line,128);p.date = line;
		f.getline(line,128);p.timeofdate = line;

		f.getline(line,128);p.car = line;
		f.getline(line,128);p.driftscore = atoi(line);
		f.getline(line,128);p.track = line;
		
		tCars* carMap = &tracks[p.track];
		tPlayers* playerMap = &(*carMap)[p.car];
		(*playerMap)[p.nickname] = p;

		(*carMap)[p.car] = *playerMap;
		tracks[p.track] = *carMap;
	}

	f.close();

	return 1;
}

int display_pbs(std::string filename, std::string carfilter, std::string trackfilter, int from, int to)
{
	tTracks tracks;
	if(!ReadPBFile(filename,tracks))
	{
		std::cout << "<p class=\"style\"><b>Could not open file " << filename << "</p>\n";
		return 0;
	}

	std::cout << "<table width=\"479\" cellspacing=\"0\" cellpadding=\"0\" border=\"1\" bordercolor=\"#FEF6D3\" style=\"font-family: Verdana; font-size: 10px; font-style: normal; font-variant: normal; text-decoration: none; color: #FFB400; font-weight: normal;\">\n";
	
	// write header of table
	std::cout << "  <tr style=\"font-family: Verdana; font-size: 10px; font-style: normal; font-variant: normal; text-decoration: none; color: #FF5400; font-weight: bold;\">\n";
	std::cout << "    <td>Rank</td>\n";
	std::cout << "    <td>Lap time</td>\n";
	std::cout << "    <td>Nickname</td>\n";
	std::cout << "    <td>1st split</td>\n";
	std::cout << "    <td>2nd split</td>\n";
	std::cout << "    <td>3rd split</td>\n";
	std::cout << "    <td>Date</td>\n";
	//std::cout << "<th>Car</th>\n";
	//std::cout << "<th>Track</th>\n";
	std::cout << "  </tr>\n";

	for(tTracks::iterator iTrack = tracks.begin(); iTrack != tracks.end(); iTrack++)
	{
		//std::cout << iTrack->first << std::endl;
		if(iTrack->first != trackfilter)
			continue;

		for(tCars::iterator iCar = iTrack->second.begin(); iCar != iTrack->second.end(); iCar++)
		{
			//std::cout << iCar->first << std::endl;
			if(iCar->first != carfilter)
				continue;
			
			std::list<Player> players;
			
			for(tPlayers::iterator iPlayer = iCar->second.begin(); iPlayer != iCar->second.end(); iPlayer++)
			{
			//	std::cout << "<tr><td>" << iPlayer->second.nickname << " - " << iPlayer->second.time << "</td></tr>" << std::endl;
				players.push_back(iPlayer->second);
			}
			
			players.sort(Player::greater);
			//std::for_each(players.begin(),players.end(),Player::write);

			int n = 1;
			for(std::list<Player>::iterator iP = players.begin(); iP != players.end(); n++,iP++)
			{
				if(n>=from && n<=to)
				{
					std::cout << "  <tr style=\"font-family: Verdana; font-size: 10px; font-style: normal; font-variant: normal; text-decoration: none; color: #FFB400; font-weight: normal;\">\n";
					std::cout << "    <td>" << n << "</td>\n";
					std::cout << "    <td>" << iP->time << "</td>\n";
					std::cout << "    <td>" << iP->nickname << "</td>\n";

					if(Player::TimeDeserialize(iP->s1) != 0)
						std::cout << "    <td>" << iP->s1 << "</td>\n";
					else
						std::cout << "    <td>&nbsp;</td>\n";

					if(Player::TimeDeserialize(iP->s2) != 0)
						std::cout << "    <td>" << iP->s2 << "</td>\n";
					else
						std::cout << "    <td>&nbsp;</td>";

					if(Player::TimeDeserialize(iP->s3) != 0)
						std::cout << "    <td>" << iP->s3 << "</td>\n";
					else
						std::cout << "    <td>&nbsp;</td>\n";

					std::cout << "    <td>" << iP->date << " " << iP->timeofdate << "</td>\n";
					std::cout << "  </tr>\n";
				}
			}

		}
	}

	std::cout<<"</table>\n";

	return 1;
}

int display_driftpbs(std::string filename, std::string carfilter, std::string trackfilter, int from, int to)
{
	tTracks tracks;
	if(!ReadDriftPBFile(filename,tracks))
	{
		std::cout << "<p class=\"style\"><b>Could not open file " << filename << "</p>\n";
		return 0;
	}

	std::cout << "<table width=\"479\" cellspacing=\"0\" cellpadding=\"2\" border\"1\" bordercolor=\"#FFB400\">\n";
	
	// write header of table
	std::cout << "  <tr>\n";
	std::cout << "    <th>Position</th>\n";
	std::cout << "    <th>Score</th>\n";
	std::cout << "    <th>Nickname</th>\n";
	std::cout << "    <th>Date</th>\n";
	//std::cout << "<th>Car</th>\n";
	//std::cout << "<th>Track</th>\n";
	std::cout << "  </tr>\n";

	for(tTracks::iterator iTrack = tracks.begin(); iTrack != tracks.end(); iTrack++)
	{
		if(iTrack->first != trackfilter)
			continue;

		for(tCars::iterator iCar = iTrack->second.begin(); iCar != iTrack->second.end(); iCar++)
		{
			if(iCar->first != carfilter)
				continue;

			std::list<Player> players;
			
			for(tPlayers::iterator iPlayer = iCar->second.begin(); iPlayer != iCar->second.end(); iPlayer++)
			{
			//	std::cout << "<tr><td>" << iPlayer->second.nickname << " - " << iPlayer->second.time << "</td></tr>" << std::endl;
				players.push_back(iPlayer->second);
			}
			
			players.sort(Player::greater_driftscore);
			//std::for_each(players.begin(),players.end(),Player::write_driftscore);
			
			int n = 1;
			for(std::list<Player>::iterator iP = players.begin(); iP != players.end(); n++,iP++)
			{
				if(n>=from && n<=to)
				{
					std::cout << "  <tr>\n";
					std::cout << "    <td>" << n << "</td>\n";
					std::cout << "    <td>" << iP->driftscore << "</td>\n";
					std::cout << "    <td>" << iP->nickname << "</td>\n";
					std::cout << "    <td>" << iP->date << " " << iP->timeofdate << "</td>\n";
					std::cout << "  </tr>\n";
				}
			}
		}
	}

	std::cout<<"</table>\n";

	return 1;
}

void FromQueryStringToMap(std::string q,std::map<std::string,std::string>& m)
{
	q = replace(q,"+"," ");

	std::list<std::string> l;
	split(q,'&',l);

	for(std::list<std::string>::iterator i = l.begin();i!=l.end();i++)
	{
		std::list<std::string> pair;
		int explen2 = split(*i,'=',pair);
		if(explen2 == 2)
		{
			std::string key = *pair.begin();
			std::string val = *(++pair.begin());
			m[key] = val;
		}
	}
}

int main()
{
	std::cout << "Content-type: text/html\n\n";
	char* env = getenv("QUERY_STRING");
	
	if(!env)env = "";

	std::map<std::string,std::string> Environment;
	FromQueryStringToMap(std::string(env),Environment);

	std::string Car = Environment["car"];
	std::string Track = Environment["track"];
	std::string Table = Environment["table"];
	int from = atoi(Environment["from"].c_str());
	int to = atoi(Environment["to"].c_str());
	std::string pbfilename = Environment["pbfile"].c_str();
	std::string driftfilename = Environment["driftfile"].c_str();

	// default options, if not found in environment
	
	if(pbfilename == "")
		pbfilename = "PB.txt";
	if(driftfilename == "")
		driftfilename = "DriftPB.txt";

	if(Car == "")
		Car = "XR GT TURBO";
	if(Track == "")
		Track = "BL1R";
	if(Table == "")
		Table = "hotlapping";
	
	if(from == 0) from = 1;
	if(to == 0) to = 15;

	std::cout << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
	std::cout << "<!-- Creator: Wonderous //-->\n";
	std::cout << "<html>\n";
	std::cout << "<head>\n";
	std::cout << "<title>LFSLapper WebStats</title>\n";
	std::cout << "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n";
	std::cout << "</head>\n";

	std::cout << "<body style=\"background-color: transparent\">\n";
	std::cout << "<div id=\"Layer 1\" style=\"position:absolute; left:0px; top:0px;\">\n";
	std::cout << "<p style=\"color: #FEF6D3; font-family: Verdana; text-decoration: none; font-size: 10px;\">&gt;<a style=\"color: #FEF6D3; font-family: Verdana; text-decoration: none; font-size: 10px;\" href=\"http://wonderous.theohbrothers.com/home.html\" target=\"_parent\"><b><u>Back to Home</u></b></a> <br>&gt;<a style=\"color: #FEF6D3; font-family: Verdana; text-decoration: none; font-size: 10px;\" href=\"http://www.theohbrothers.com/myservers/lfs/lfslapper.html\" target=\"_parent\"><b><u>View Live For Speed Server Status</u></b></a>";
	std::cout << "</p>\n";
	/*
	if(env)
		std::cout << "<p>" << env << "</p>\n";	//testing environment string
	*/

	if(Table == "hotlapping")
	{
		//std::string pbfilename = "PB.txt";
		display_pbs(pbfilename, Car, Track, from, to);
	}
	else if(Table == "drifting")
	{
		//std::string driftfilename = "DriftPB.txt";
		display_driftpbs(driftfilename, Car, Track, from, to);
	}

	//std::cout << "<p><a href=\"http://validator.w3.org/check/referer\"><img src=\"http://www.w3.org/Icons/valid-xhtml10\" alt=\"Valid XHTML 1.0!\" height=\"31\" width=\"88\" /></a></p>";
    std::cout << "<br><br><br><br>\n";
	std::cout << "<p style=\"font-family: Verdana; font-size: 10px; font-style: normal; font-variant: normal; text-decoration: none; color: #FFB400; font-weight: bold;\"><font color=\"white\">&middot; LFSLapper output information</font> <font color=\"yellow\">is powered by</font> <font color=\"#00FFFF\">WebStats v1.2 !</font>\n";
	std::cout << "Script developer: <a href=\"http://monkster.hopto.org/~janez\" target=\"_blank\" style=\"color: #FEF6D3; font-family: Verdana; text-decoration: none; font-size: 10px;\">Janez Cufer</a></p>\n";
	std::cout << "</body>\n";
	std::cout << "</html>\n";
	std::cout << "<!-- Creator: Wonderous //-->";
	return 0;
}