/*
 * Copyright Karl Southern 2007
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#include <stdio.h>

#include "version.h"
#include "ilua.h"
#include "insim.h"
#include "events.h"

lua_State* L;
insim_t *I;

int main (int argc, char *argv[])
{
    printf("LuaLFS %s\nPowered By %s\n\n", VERSION, LUA_VERSION);
	ilua_init();
	ilua_load();
	printf("\n");

    I = insim_create();

    I->listen_address = "127.0.0.1";
    I->listen_port = 29998;
    I->send_address = "127.0.0.1";
    I->send_port = 29999;
    I->admin_password = NULL;
    I->flags = ISF_RACE_TRACKING | ISF_KEEP_ALIVE;
    I->node_secs = 180;
    I->last_contact = time(NULL);

    insim_connect(I);

    while (insim_recv(I) > 0)
        ;

	ilua_evt_fire(EVT_DISCONNECTED, NULL, 0);
	ilua_evt_fire(EVT_SHUTDOWN, NULL, 0);

    insim_destroy(I);

    ilua_close();
	return 0;
}
