/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class TVcameratool
implements ClipboardOwner,
ActionListener {
    Clipboard clipboard;
    static final String CONFIG_FILE = "config.txt";
    static final String CAMERA_FILE = "cams.txt";
    static final int POSITIVE_X = 0;
    static final int NEGATIVE_X = 1;
    static final int POSITIVE_Y = 2;
    static final int NEGATIVE_Y = 3;
    static final int POSITIVE_Z = 4;
    static final int NEGATIVE_Z = 5;
    static final int STEP = 65536;
    public static boolean forceRequest = false;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int heading = 0;
    public int pitch = 0;
    public int roll = 0;
    public float fov = 0.0f;
    static DatagramSocket socket = null;
    static TVin IO_IN = null;
    static TVout IO_OUT = null;
    static TV TVdirector = null;
    static TVcam t = null;
    JPanel infoPanel;
    JTextArea textArea;
    String cameraText = "";
    int carX;
    int carY;
    int carZ;
    int numNodes;
    int finishLineNode;
    int playerNode;

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public static void waitHun(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Problems...");
        }
    }

    public static void displayCameraProperties(TVcam tVcam) {
        System.out.println("\n");
        System.out.println("X : " + tVcam.vecX);
        System.out.println("Y : " + tVcam.vecY);
        System.out.println("Z : " + tVcam.vecZ);
        System.out.println("H : " + tVcam.heading);
        System.out.println("P : " + tVcam.pitch);
        System.out.println("R : " + tVcam.roll);
        System.out.println("FOV : " + tVcam.fov);
        System.out.println("\n");
    }

    public void buildMenu() {
        JFrame jFrame = new JFrame("LFS Director Camera Tool");
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setLocation(100, 100);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 1));
        this.infoPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        this.textArea = new JTextArea("\n\n\n\n\n\n\n\n\n\n\n\n");
        this.textArea.setFont(new Font("Courier New", 0, 12));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.infoPanel.add(this.textArea);
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        JButton jButton = new JButton("Copy data");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new GridLayout(4, 3, 0, 0));
        JButton jButton2 = new JButton("X+");
        jButton2.addMouseListener(new controlAdapter(0));
        JButton jButton3 = new JButton("X-");
        jButton3.addMouseListener(new controlAdapter(1));
        JButton jButton4 = new JButton("Y+");
        jButton4.addMouseListener(new controlAdapter(2));
        JButton jButton5 = new JButton("Y-");
        jButton5.addMouseListener(new controlAdapter(3));
        JButton jButton6 = new JButton("Z+");
        jButton6.addMouseListener(new controlAdapter(4));
        JButton jButton7 = new JButton("Z-");
        jButton7.addMouseListener(new controlAdapter(5));
        jPanel2.add(jButton7);
        jPanel2.add(new JLabel());
        jPanel2.add(jButton6);
        jPanel2.add(new JLabel());
        jPanel2.add(jButton4);
        jPanel2.add(new JLabel());
        jPanel2.add(jButton3);
        jPanel2.add(new JLabel());
        jPanel2.add(jButton2);
        jPanel2.add(new JLabel());
        jPanel2.add(jButton5);
        jPanel2.add(new JLabel());
        jFrame.getContentPane().add(jPanel2);
        jFrame.getContentPane().add(this.infoPanel);
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public TVcameratool() {
        boolean bl = false;
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        System.out.print("Reading config file...");
        TVParseConfig tVParseConfig = new TVParseConfig(CONFIG_FILE);
        String string = tVParseConfig.getIP();
        String string2 = tVParseConfig.getPass();
        int n = tVParseConfig.getPort();
        System.out.println(" OK");
        try {
            socket = new DatagramSocket();
            InetAddress inetAddress = InetAddress.getByName(string);
            socket.connect(inetAddress, n);
            socket.setSoTimeout(10000);
            IO_IN = new TVin(socket);
            IO_OUT = new TVout(socket);
            TVdirector = new TV(IO_IN, IO_OUT);
            TVdirector.sendInit(0, true, string2);
            TVdirector.sendNLI(1000);
        }
        catch (SocketException socketException) {
            System.exit(0);
        }
        catch (UnknownHostException unknownHostException) {
            System.exit(0);
        }
        this.buildMenu();
        long l = 0L;
        while (!bl) {
            if (l + 1000L < System.currentTimeMillis() || forceRequest) {
                TVdirector.requestCamPacket();
                l = System.currentTimeMillis();
                forceRequest = false;
            }
            IO_IN.receive();
            byte[] byArray = IO_IN.getRec();
            String string3 = TVdirector.getHeader(byArray);
            if (string3.equals("STA")) {
                TVdirector.processSTA(byArray);
            }
            if (string3.equals("CPP")) {
                t = TVdirector.processCPP(byArray);
                this.x = TVcameratool.t.vecX;
                this.y = TVcameratool.t.vecY;
                this.z = TVcameratool.t.vecZ;
                this.heading = TVcameratool.t.heading;
                this.pitch = TVcameratool.t.pitch;
                this.roll = TVcameratool.t.roll;
                this.fov = TVcameratool.t.fov;
                this.updateMenu();
            }
            if (string3.equals("MSO")) {
                if (TVdirector.byteToString(byArray, 3, 128).indexOf("stop java") > -1) {
                    bl = true;
                }
                if (TVdirector.byteToString(byArray, 3, 128).indexOf("up") > -1) {
                    TVcameratool.t.vecZ += 65536;
                    TVdirector.setStateFlags(TVdirector.getStateFlags() & 0x3E4F);
                    TVdirector.setStateFlags(TVdirector.getStateFlags() | 8);
                    TVdirector.setStateFlags(TVdirector.getStateFlags() | 0x2000);
                    TVdirector.sendCPP(t, 0, 0);
                    forceRequest = true;
                }
            }
            if (string3.equals("MCI")) {
                this.numNodes = (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
                this.finishLineNode = (byArray[7] & 0xFF) << 8 | byArray[6] & 0xFF;
                this.playerNode = ((byArray[13] & 0xFF) << 8 | byArray[12] & 0xFF) & 0x1FFFF;
                this.playerNode -= this.finishLineNode;
                if (this.playerNode < 0) {
                    this.playerNode = this.numNodes + this.playerNode;
                }
                int n2 = (byArray[19] & 0xFF) << 24 | (byArray[18] & 0xFF) << 16 | (byArray[17] & 0xFF) << 8 | byArray[16] & 0xFF;
                int n3 = (byArray[23] & 0xFF) << 24 | (byArray[22] & 0xFF) << 16 | (byArray[21] & 0xFF) << 8 | byArray[20] & 0xFF;
                int n4 = (byArray[27] & 0xFF) << 24 | (byArray[26] & 0xFF) << 16 | (byArray[25] & 0xFF) << 8 | byArray[24] & 0xFF;
                this.carX = n2;
                this.carY = n3;
                this.carZ = n4;
                this.updateMenu();
            }
            this.updateMenu();
            IO_OUT.keepAlive();
        }
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        new TVcameratool();
    }

    public void updateMenu() {
        String string = "track=" + TVdirector.getTrack() + "\n" + "x=" + this.x + "\n" + "y=" + this.y + "\n" + "z=" + this.z + "\n" + "heading=" + this.heading + "\n" + "pitch=" + this.pitch + "\n" + "roll=" + this.roll + "\n" + "fov=" + this.fov + "\n" + "\n" + "node=" + this.playerNode + "\n" + "carX=" + this.carX + "\n" + "carY=" + this.carY + "\n";
        if (!string.equals(this.cameraText)) {
            this.textArea.setText(string);
            this.cameraText = string;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        StringSelection stringSelection = new StringSelection(this.cameraText);
        this.clipboard.setContents(stringSelection, this);
    }

    class controlAdapter
    extends MouseAdapter {
        public int control = -1;

        public controlAdapter(int n) {
            this.control = n;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.control == 0) {
                TVcameratool.t.vecX += 65536;
            } else if (this.control == 1) {
                TVcameratool.t.vecX -= 65536;
            } else if (this.control == 2) {
                TVcameratool.t.vecY += 65536;
            } else if (this.control == 3) {
                TVcameratool.t.vecY -= 65536;
            } else if (this.control == 4) {
                TVcameratool.t.vecZ += 65536;
            } else if (this.control == 5) {
                TVcameratool.t.vecZ -= 65536;
            }
            TVdirector.setStateFlags(TVdirector.getStateFlags() & 0x3E4F);
            TVdirector.setStateFlags(TVdirector.getStateFlags() | 8);
            TVdirector.setStateFlags(TVdirector.getStateFlags() | 0x2000);
            TVdirector.sendCPP(t, 0, 0);
            forceRequest = true;
        }
    }
}

