/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class TVCameraControlMethods
extends Thread {
    protected final int LFS_CAM = 0;
    protected final int CUSTOM_CAM = 1;
    protected final int LFS_ARCADE = 0;
    protected final int LFS_HELICOPTER = 1;
    protected final int LFS_TVCAM = 2;
    protected final int LFS_DRIVER = 3;
    protected final int LFS_CUSTOM = 4;
    protected final int CUSTOM_EXTERNAL = 0;
    protected TV TVdirector;
    protected ControlPanel controlPanel;
    protected TVconnection primaryConnection;
    protected TVconnection secondaryConnection;
    protected long primaryChangeTime;
    protected long secondaryChangeTime;
    protected TVcam[] staticCams = new TVcam[0];
    protected TVcam[] staticCamsThisTrack = new TVcam[0];
    protected String statusCorner;
    protected boolean stop = false;
    protected boolean work = false;
    protected boolean prevWasCustom = true;
    protected boolean forceChoseNewCam = true;
    int closeCam;
    int prevCam = 0;
    int prevLFSCam = -1;
    int prevPrimary = -1;
    double pos = 0.0;
    protected String track = "";
    protected String cameraSet = "";
    protected int[] closeCams = new int[5];
    protected Random randCam = new Random();
    long lastChange;
    int prevHead = 0;

    public TVCameraControlMethods() {
        for (int i = 0; i < this.closeCams.length; ++i) {
            this.closeCams[i] = -1;
        }
    }

    public boolean isInArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public int[] reduceCamList(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            ++n;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length && n2 < n; ++n2, ++i) {
            if (nArray[i] == -1) continue;
            nArray2[n2] = nArray[i];
        }
        return nArray2;
    }

    public void setTV(TV tV) {
        this.TVdirector = tV;
    }

    public void setControlPanel(ControlPanel controlPanel) {
        this.controlPanel = controlPanel;
    }

    public void setRun(boolean bl) {
        this.stop = bl;
    }

    public void setWork(boolean bl) {
        this.work = bl;
    }

    public void setPrimaryConnection(TVconnection tVconnection) {
        if (tVconnection == null) {
            System.out.println("Got a nullpointer - Primary");
        }
        this.primaryConnection = tVconnection;
        this.primaryChangeTime = System.currentTimeMillis();
        this.work = true;
        this.forceChoseNewCam = true;
    }

    public void setSecondaryConnection(TVconnection tVconnection) {
        if (tVconnection == null) {
            System.out.println("Got a nullpointer - Secondary");
        }
        this.secondaryConnection = tVconnection;
        this.secondaryChangeTime = System.currentTimeMillis();
        this.work = true;
        this.forceChoseNewCam = true;
    }

    public void resetPrimary() {
        this.primaryConnection = null;
        this.forceChoseNewCam = true;
    }

    public void resetSecondary() {
        this.secondaryConnection = null;
        this.forceChoseNewCam = true;
    }

    public void setTrackAndCameraSet() {
        String string = this.TVdirector.getTrack();
        String string2 = this.controlPanel.getCurrentCameraSet();
        if (!(this.track.equals(string) && this.cameraSet.equals(string2) || this.staticCams == null)) {
            int n;
            this.track = string;
            this.cameraSet = string2;
            int n2 = 0;
            for (n = 0; n < this.staticCams.length; ++n) {
                if (!this.staticCams[n].getTrack().equals(this.track) || !this.staticCams[n].getSetName().equals(this.cameraSet)) continue;
                ++n2;
            }
            this.staticCamsThisTrack = new TVcam[n2];
            n = 0;
            for (int i = 0; i < this.staticCams.length; ++i) {
                if (!this.staticCams[i].getTrack().equals(this.track) || !this.staticCams[i].getSetName().equals(this.cameraSet)) continue;
                this.staticCamsThisTrack[n] = this.staticCams[i];
                ++n;
            }
        }
        this.forceChoseNewCam = true;
    }

    public void setStaticCams(TVcam[] tVcamArray) {
        this.staticCams = tVcamArray;
        this.forceChoseNewCam = true;
    }

    public double getVectorsAngle(double[] dArray, double[] dArray2) {
        double d = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        double d2 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d3 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
        double d4 = Math.acos(d / (d2 * d3));
        return d4;
    }

    public int radToLfs(double d) {
        return (int)(d / Math.PI * 32768.0);
    }

    public void pauseFor(int n) {
        try {
            TVCameraControlMethods.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("I was interrupted.");
        }
    }

    public void run() {
        System.out.println("Working!");
    }
}

