/*
 * Decompiled with CFR 0.152.
 */
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class TVmain {
    final String CONFIG_FILE = "config.txt";
    private byte[] p;
    private boolean stop = false;
    private boolean primarySucces;
    private boolean secondarySucces;
    private DatagramSocket socket = null;
    private TVParseCamFile tvParseCam;
    private TVParseConfig parseConfig;
    private TVParseTeamFile tvParseTeam;
    private TVin IO_IN;
    private TVout IO_OUT;
    private TV TVdirector;
    private ControlPanel controlPanel;
    private TVCameraControl cameraControl;
    private TVconnection primaryConnection;
    private TVconnection secondaryConnection;
    private int primaryUniqueID;
    private int secondaryUniqueID;
    private long prevKeepAlive;
    private long prevButtonStatusUpdate;
    private long prevGridStatusUpdate;
    private boolean prevStateISSGAME;

    public static void waitHun(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Problems...");
        }
    }

    public TVmain() {
        Object object;
        System.out.print("Reading config file...");
        this.parseConfig = new TVParseConfig("config.txt");
        String string = this.parseConfig.getIP();
        String string2 = this.parseConfig.getPass();
        int n = this.parseConfig.getPort();
        System.out.println(" OK");
        try {
            this.socket = new DatagramSocket();
            object = InetAddress.getByName(string);
            this.socket.connect((InetAddress)object, n);
            this.socket.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            System.out.println("Error 1: " + socketException.getMessage());
            System.exit(0);
        }
        catch (SecurityException securityException) {
            System.out.println("Error 2: " + securityException.getMessage());
            System.exit(0);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Error 3: " + unknownHostException.getMessage());
            System.exit(0);
        }
        this.IO_IN = new TVin(this.socket);
        this.IO_OUT = new TVout(this.socket);
        this.TVdirector = new TV(this.IO_IN, this.IO_OUT);
        this.TVdirector.sendInit(0, true, string2);
        this.TVdirector.sendNLI(100);
        System.out.print("Reading camera file...");
        this.tvParseCam = new TVParseCamFile();
        System.out.println(" OK");
        this.tvParseTeam = new TVParseTeamFile();
        this.controlPanel = new ControlPanel(this.tvParseCam.getSetNames());
        this.controlPanel.setTV(this.TVdirector);
        this.controlPanel.setTeams(this.tvParseTeam.getTeams());
        this.TVdirector.setTeams(this.tvParseTeam.getTeams());
        this.TVdirector.setPoleside(this.tvParseTeam.getPoleside());
        this.cameraControl = new TVCameraControl();
        this.cameraControl.setTV(this.TVdirector);
        this.cameraControl.setControlPanel(this.controlPanel);
        this.cameraControl.setPriority(6);
        this.cameraControl.setStaticCams(this.tvParseCam.getCams());
        this.controlPanel.setTVCameraControl(this.cameraControl);
        this.TVdirector.setTVCameraControl(this.cameraControl);
        this.TVdirector.setControlPanel(this.controlPanel);
        this.prevKeepAlive = System.currentTimeMillis();
        this.prevButtonStatusUpdate = System.currentTimeMillis();
        this.prevStateISSGAME = false;
        this.cameraControl.start();
        this.controlPanel.setStatus("Camera control started.");
        while (!this.stop) {
            if (this.TVdirector.getStateFlags() == 0) {
                this.TVdirector.sendSTArequest();
            }
            this.IO_IN.receive();
            if (this.IO_IN.getTimeout()) continue;
            this.p = this.IO_IN.getRec();
            if (this.p.length == 0) continue;
            object = this.TVdirector.getHeader(this.p);
            if (((String)object).equals("NLP")) {
                this.TVdirector.processNLP(this.p);
            }
            if (((String)object).equals("LAP")) {
                this.TVdirector.processLAP(this.p);
            }
            if (((String)object).equals("MCI")) {
                this.TVdirector.processMCI(this.p);
            }
            if (((String)object).equals("NPL")) {
                this.TVdirector.processNPL(this.p);
            }
            if (((String)object).equals("PLL")) {
                this.TVdirector.processPLL(this.p);
            }
            if (((String)object).equals("PLP")) {
                this.TVdirector.processPLP(this.p);
            }
            if (((String)object).equals("CNL")) {
                this.TVdirector.processCNL(this.p);
            }
            if (((String)object).equals("CPR")) {
                this.TVdirector.processCPR(this.p);
            }
            if (((String)object).equals("CLR")) {
                this.TVdirector.processCLR(this.p);
            }
            if (((String)object).equals("REN")) {
                this.TVdirector.processREN(this.p);
            }
            if (((String)object).equals("STA")) {
                this.TVdirector.processSTA(this.p);
            }
            if (((String)object).equals("RST")) {
                this.TVdirector.processRST(this.p);
            }
            if (((String)object).equals("MSO")) {
                this.TVdirector.processMSO(this.p);
            }
            this.primaryUniqueID = this.controlPanel.getPrimaryUniqueID();
            this.secondaryUniqueID = this.controlPanel.getSecondaryUniqueID();
            this.primarySucces = false;
            this.secondarySucces = false;
            this.primaryConnection = null;
            this.secondaryConnection = null;
            if (this.primaryUniqueID != -1) {
                try {
                    this.primaryConnection = this.TVdirector.getConnection(this.primaryUniqueID);
                    this.primarySucces = !this.primaryConnection.getPits() && !this.primaryConnection.getSpectate();
                }
                catch (TVException tVException) {
                    this.primarySucces = false;
                }
            }
            if (this.secondaryUniqueID != -1) {
                try {
                    this.secondaryConnection = this.TVdirector.getConnection(this.secondaryUniqueID);
                    this.secondarySucces = !this.secondaryConnection.getPits() && !this.secondaryConnection.getSpectate();
                }
                catch (TVException tVException) {
                    this.secondarySucces = false;
                }
            }
            if (this.primarySucces && this.secondarySucces) {
                this.cameraControl.setPrimaryConnection(this.primaryConnection);
                this.cameraControl.setSecondaryConnection(this.secondaryConnection);
                this.cameraControl.setWork(true);
            } else if (this.primarySucces && !this.secondarySucces) {
                this.cameraControl.setPrimaryConnection(this.primaryConnection);
                this.cameraControl.resetSecondary();
                if (this.secondaryUniqueID != -1) {
                    this.controlPanel.resetSecondary();
                }
                this.cameraControl.setWork(true);
            } else if (!this.primarySucces && this.secondarySucces) {
                this.cameraControl.setPrimaryConnection(this.secondaryConnection);
                this.cameraControl.resetSecondary();
                this.controlPanel.setPrimaryUniqueID(this.secondaryUniqueID);
                this.controlPanel.resetSecondary();
                this.cameraControl.setWork(true);
            } else {
                this.cameraControl.setWork(false);
                this.cameraControl.resetPrimary();
                this.cameraControl.resetSecondary();
            }
            if (!this.TVdirector.getStateISSGAME()) {
                this.cameraControl.setWork(false);
                this.cameraControl.resetPrimary();
                this.cameraControl.resetSecondary();
            }
            if (this.prevStateISSGAME != this.TVdirector.getStateISSGAME()) {
                this.controlPanel.updateButtons();
                this.prevStateISSGAME = this.TVdirector.getStateISSGAME();
            }
            this.checkPlayerNames();
            this.TVdirector.checkGrid();
            this.buttonStatusUpdate();
            this.gridStatusUpdate();
            this.keepAlive();
        }
        System.exit(0);
    }

    public void checkPlayerNames() {
        for (int i = 0; i < TVget.connections.length; ++i) {
            if (TVget.connections[i].getUserName() != null) continue;
            this.TVdirector.sendNPL(TVget.connections[i].playerNumber);
            TVget.connections[i].setUserName("");
            break;
        }
    }

    public void buttonStatusUpdate() {
        if (this.prevButtonStatusUpdate + 1000L < System.currentTimeMillis()) {
            this.controlPanel.updateButtons();
            this.prevButtonStatusUpdate = System.currentTimeMillis();
        }
    }

    public void gridStatusUpdate() {
        if (this.prevGridStatusUpdate + 200L < System.currentTimeMillis()) {
            this.TVdirector.showHelper();
            this.controlPanel.updateGrid();
            this.prevGridStatusUpdate = System.currentTimeMillis();
        }
    }

    public void keepAlive() {
        if (this.prevKeepAlive + 10000L < System.currentTimeMillis()) {
            this.IO_OUT.keepAlive();
            this.prevKeepAlive = System.currentTimeMillis();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new TVmain();
    }
}

