/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class TVget
extends TVGameStatus {
    public static TVconnection[] connections = new TVconnection[0];
    public static TVconnection[] tempconnections;
    int MCI_NUM = 0;
    long mcitime;
    private int mci_x;
    private int mci_y;
    private int mci_z;
    private int mci_speed;
    private int mci_head;
    private int mci_direction;
    private int mci_angVel;
    private int mci_firstPlayer;
    private int PACKET_SIZE = 24;
    private int mci_uniqueID;
    private int mci_playerNode;
    private int mci_playerLap;
    private int mci_iterations;
    private boolean updatefoo;

    public TVget(TVin tVin, TVout tVout) {
        super(tVin, tVout);
    }

    public String getHeader(byte[] byArray) {
        String string = "";
        string = string + (char)byArray[0];
        string = string + (char)byArray[1];
        string = string + (char)byArray[2];
        return string;
    }

    public String byteToString(byte[] byArray, int n, int n2) {
        String string = "";
        for (int i = n; i < Math.min(byArray.length, n2); ++i) {
            if (byArray[i] == 0) continue;
            string = string + (char)byArray[i];
        }
        return string;
    }

    public int addConnectionSpot() {
        int n;
        tempconnections = connections;
        connections = new TVconnection[tempconnections.length + 1];
        for (n = 0; n < tempconnections.length; ++n) {
            TVget.connections[n] = tempconnections[n];
        }
        TVget.connections[n] = new TVconnection();
        return n;
    }

    public int getCurrentIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < connections.length; ++i) {
            if (TVget.connections[i].uniqueID != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public void removeConnectionSpot(String string) {
        int n;
        int n2 = -1;
        for (n = 0; n < connections.length; ++n) {
            if (!connections[n].getUserName().equals(string)) continue;
            n2 = n;
        }
        if (n2 != -1) {
            tempconnections = connections;
            connections = new TVconnection[tempconnections.length - 1];
            for (n = 0; n < n2; ++n) {
                TVget.connections[n] = tempconnections[n];
            }
            for (n = n2 + 1; n < tempconnections.length; ++n) {
                TVget.connections[n - 1] = tempconnections[n];
            }
        }
    }

    public void processSTA(byte[] byArray) {
        this.setReplaySpeed(ByteBuffer.wrap(byArray, 4, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat());
        this.setStateFlags((byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF);
        this.setInGameCam(byArray[10]);
        this.setViewPlayer(byArray[11]);
        this.setNumPlayers(byArray[12]);
        this.setNumConns(byArray[13]);
        this.setNumFinished(byArray[14]);
        this.setRaceInProgress(byArray[15]);
        this.setQualMins(byArray[16]);
        this.setRaceLaps(byArray[17]);
        this.setTrack(this.byteToString(byArray, 20, 25));
        this.setWeather(byArray[25]);
        this.setWind(byArray[26]);
        if (this.controlPanel != null) {
            this.controlPanel.setStatus("Number of players : " + this.getNumPlayers());
        }
        if (this.cameraControl != null) {
            this.cameraControl.setTrackAndCameraSet();
        }
    }

    public void processRST(byte[] byArray) {
        this.setRaceLaps(byArray[4]);
        this.setQualMins(byArray[5]);
        this.setNumPlayers(byArray[6]);
        this.setTrack(this.byteToString(byArray, 8, 13));
        this.setWeather(byArray[14]);
        this.setWind(byArray[15]);
        this.IO_OUT.keepAlive(byArray[18], byArray[19]);
    }

    public void processREN(byte[] byArray) {
        System.out.println("REN : Removing all connections...");
        this.setNumPlayers(0);
        this.setRaceEnd(true);
        this.IO_OUT.keepAlive(byArray[6], byArray[7]);
        this.controlPanel.resetPrimary();
        this.controlPanel.resetSecondary();
        this.cameraControl.setWork(false);
        this.cameraControl.resetPrimary();
        this.cameraControl.resetSecondary();
        connections = new TVconnection[0];
        this.controlPanel.updateButtons();
    }

    public void processNCN(byte[] byArray) {
        this.IO_OUT.keepAlive(byArray[58], byArray[59]);
    }

    public void processCNL(byte[] byArray) {
        System.out.println("CNL : Connection leave...");
        String string = this.byteToString(byArray, 4, 27);
        this.IO_OUT.keepAlive(byArray[54], byArray[55]);
        this.removeConnectionSpot(string);
        this.controlPanel.updateButtons();
    }

    public void processNPL(byte[] byArray) {
        String string = this.byteToString(byArray, 4, 27);
        String string2 = this.byteToString(byArray, 28, 51);
        String string3 = this.byteToString(byArray, 52, 59);
        String string4 = this.byteToString(byArray, 60, 63);
        byte by = byArray[95];
        this.IO_OUT.keepAlive(byArray[98], byArray[99]);
        int n = this.getCurrentIndex(by);
        if (n == -1) {
            n = this.addConnectionSpot();
            connections[n].setUniqueID(by);
        }
        connections[n].setUserName(string);
        connections[n].setPlayerName(string2);
        connections[n].setPlate(string3);
        connections[n].setCarName(string4);
        connections[n].setPits(false);
        connections[n].setSpectate(false);
        this.controlPanel.updateButtons();
    }

    public void processPLP(byte[] byArray) {
        byte by = byArray[52];
        int n = this.getCurrentIndex(by);
        System.out.println("PLP : Player to pits (" + by + ")");
        if (n != -1) {
            connections[n].setPits(true);
        }
        this.IO_OUT.keepAlive(byArray[58], byArray[59]);
        this.controlPanel.updateButtons();
    }

    public void processPLL(byte[] byArray) {
        System.out.println("PLL : Player spectating...");
        byte by = byArray[52];
        int n = this.getCurrentIndex(by);
        if (n != -1) {
            connections[n].setSpectate(true);
        }
        this.IO_OUT.keepAlive(byArray[58], byArray[59]);
        this.controlPanel.updateButtons();
    }

    public void processCPR(byte[] byArray) {
        System.out.println("CPR : Renaming a player...");
        String string = this.byteToString(byArray, 52, 75);
        byte by = byArray[84];
        int n = this.getCurrentIndex(by);
        if (n != -1) {
            connections[n].setPlayerName(string);
        }
        this.IO_OUT.keepAlive(byArray[86], byArray[87]);
        this.controlPanel.updateButtons();
    }

    public void processCLR(byte[] byArray) {
        this.setNumPlayers(0);
        this.setRaceEnd(true);
        System.out.println("CLR : Removing all connections...");
        connections = new TVconnection[0];
        this.IO_OUT.keepAlive(byArray[6], byArray[7]);
        this.controlPanel.updateButtons();
    }

    public void processMSO(byte[] byArray) {
    }

    public void processLAP(byte[] byArray) {
        String string = this.byteToString(byArray, 4, 27);
        String string2 = this.byteToString(byArray, 28, 51);
        byte by = byArray[89];
        int n = this.getCurrentIndex(by);
        if (!(n == -1 || connections[n].getUserName().equals(string) && connections[n].getPlayerName().equals(string2))) {
            connections[n].setUserName(string);
            connections[n].setPlayerName(string2);
            this.controlPanel.updateButtons();
        }
        this.IO_OUT.keepAlive(byArray[90], byArray[91]);
    }

    public void processSPX(byte[] byArray) {
        this.IO_OUT.keepAlive(byArray[10], byArray[11]);
    }

    public void processRES(byte[] byArray) {
        this.IO_OUT.keepAlive(byArray[106], byArray[107]);
    }

    public void processREO(byte[] byArray) {
        this.IO_OUT.keepAlive(byArray[62], byArray[63]);
    }

    public void processNLP(byte[] byArray) {
        int n;
        int n2 = 4;
        this.setNumNodes((byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF);
        this.setFinishLineNode((byArray[7] & 0xFF) << 8 | byArray[6] & 0xFF);
        this.setNumPlayers(byArray[8]);
        if (this.getNumPlayers() > connections.length) {
            tempconnections = connections;
            connections = new TVconnection[this.getNumPlayers()];
            for (n = 0; n < tempconnections.length; ++n) {
                TVget.connections[n] = tempconnections[n];
            }
            for (n = tempconnections.length; n < this.getNumPlayers(); ++n) {
                TVget.connections[n] = new TVconnection();
            }
        }
        for (n = 0; n < this.getNumPlayers(); ++n) {
            int n3 = (byArray[13 + n * n2] & 0xFF) << 8 | byArray[12 + n * n2] & 0xFF;
            byte by = byArray[14 + n * n2];
            byte by2 = byArray[15 + n * n2];
            if ((n3 -= this.getFinishLineNode()) < 0) {
                n3 = this.getNumNodes() + n3;
            }
            int n4 = this.getCurrentIndex(by2);
            TVget.connections[n4] = new TVconnection(by, n3, by2);
        }
    }

    public void processMCI(byte[] byArray) {
        this.setNumNodes((byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF);
        this.setFinishLineNode((byArray[7] & 0xFF) << 8 | byArray[6] & 0xFF);
        this.setNumPlayers(byArray[8]);
        this.mci_firstPlayer = byArray[9];
        this.mci_iterations = this.getNumPlayers() - this.mci_firstPlayer;
        for (int i = 0; i < Math.min(this.mci_iterations, 8); ++i) {
            int n;
            this.mci_uniqueID = byArray[15 + i * this.PACKET_SIZE];
            if (this.mci_uniqueID == 0) continue;
            this.mci_playerNode = ((byArray[13 + i * this.PACKET_SIZE] & 0xFF) << 8 | byArray[12 + i * this.PACKET_SIZE] & 0xFF) & 0x1FFF;
            this.mci_playerLap = byArray[14 + i * this.PACKET_SIZE] | (this.mci_playerNode & 0xE000) >> 5;
            this.mci_x = (byArray[19 + i * this.PACKET_SIZE] & 0xFF) << 24 | (byArray[18 + i * this.PACKET_SIZE] & 0xFF) << 16 | (byArray[17 + i * this.PACKET_SIZE] & 0xFF) << 8 | byArray[16 + i * this.PACKET_SIZE] & 0xFF;
            this.mci_y = (byArray[23 + i * this.PACKET_SIZE] & 0xFF) << 24 | (byArray[22 + i * this.PACKET_SIZE] & 0xFF) << 16 | (byArray[21 + i * this.PACKET_SIZE] & 0xFF) << 8 | byArray[20 + i * this.PACKET_SIZE] & 0xFF;
            this.mci_z = (byArray[27 + i * this.PACKET_SIZE] & 0xFF) << 24 | (byArray[26 + i * this.PACKET_SIZE] & 0xFF) << 16 | (byArray[25 + i * this.PACKET_SIZE] & 0xFF) << 8 | byArray[24 + i * this.PACKET_SIZE] & 0xFF;
            this.mci_speed = (byArray[29 + i * this.PACKET_SIZE] & 0xFF) << 8 | byArray[28 + i * this.PACKET_SIZE] & 0xFF;
            this.mci_direction = (byArray[31 + i * this.PACKET_SIZE] & 0xFF) << 8 | byArray[30 + i * this.PACKET_SIZE] & 0xFF;
            this.mci_head = (byArray[33 + i * this.PACKET_SIZE] & 0xFF) << 8 | byArray[32 + i * this.PACKET_SIZE] & 0xFF;
            this.mci_angVel = (byArray[35 + i * this.PACKET_SIZE] & 0xFF) << 8 | byArray[34 + i * this.PACKET_SIZE] & 0xFF;
            this.mci_playerNode -= this.getFinishLineNode();
            if (this.mci_playerNode < 0) {
                this.mci_playerNode = this.getNumNodes() + this.mci_playerNode;
            }
            if ((n = this.getCurrentIndex(this.mci_uniqueID)) == -1) {
                n = this.addConnectionSpot();
            }
            if (TVget.connections[n].uniqueID != this.mci_uniqueID) {
                this.updatefoo = true;
            }
            TVget.connections[n].z_prev = TVget.connections[n].z;
            connections[n].set(this.mci_playerLap, this.mci_playerNode, this.mci_uniqueID, this.mci_x, this.mci_y, this.mci_z, this.mci_speed, this.mci_direction, this.mci_head, this.mci_angVel);
            connections[n].setPlayerNumber(i + this.mci_firstPlayer);
            if (this.updatefoo) {
                this.controlPanel.updateButtons();
            }
            this.updatefoo = false;
        }
    }

    public TVcam processCPP(byte[] byArray) {
        int n = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n2 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        int n3 = (byArray[15] & 0xFF) << 24 | (byArray[14] & 0xFF) << 16 | (byArray[13] & 0xFF) << 8 | byArray[12] & 0xFF;
        int n4 = (byArray[17] & 0xFF) << 8 | byArray[16] & 0xFF;
        int n5 = (byArray[19] & 0xFF) << 8 | byArray[18] & 0xFF;
        int n6 = (byArray[21] & 0xFF) << 8 | byArray[20] & 0xFF;
        float f = ByteBuffer.wrap(byArray, 24, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat();
        int n7 = (byArray[29] & 0xFF) << 8 | byArray[28] & 0xFF;
        return new TVcam(n, n2, n3, n4, n5, n6, f, n7, 0, 0, true);
    }
}

