/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class TVParseCamFile {
    static TVcam[] cams;
    String[] cameraSets;
    FileFilter onlyDirectories = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    FileFilter noDirectories = new FileFilter(){

        public boolean accept(File file) {
            return !file.isDirectory() && !file.getName().startsWith(".") && file.getName().endsWith(".txt");
        }
    };
    private BufferedWriter camLog;

    public TVParseCamFile() {
        try {
            File file = new File("cams");
            File[] fileArray = file.listFiles(this.onlyDirectories);
            this.camLog = new BufferedWriter(new FileWriter("cameralog.txt"));
            if (fileArray == null) {
                this.camLog.write("No directories found.\n");
            } else {
                this.cameraSets = new String[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    this.cameraSets[i] = fileArray[i].getName();
                    File file2 = new File("cams/" + fileArray[i].getName());
                    File[] fileArray2 = file2.listFiles(this.noDirectories);
                    if (fileArray2 == null) continue;
                    for (int j = 0; j < fileArray2.length; ++j) {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray2[j]));
                        boolean bl = false;
                        TVcam tVcam = new TVcam();
                        boolean bl2 = false;
                        while (!bl) {
                            String string;
                            String string2 = bufferedReader.readLine();
                            if (string2 == null) {
                                bl = true;
                                continue;
                            }
                            if (string2.length() == 0 || string2.substring(0, 1).equals("?")) continue;
                            int n = string2.indexOf("=");
                            if (n == -1) {
                                n = string2.length();
                            }
                            if ((string = string2.substring(0, n)).equals("startCam")) {
                                if (bl2) {
                                    this.camLog.write("'startCam' found before 'stopCam' of " + fileArray2[j] + "\\" + tVcam.getName() + "\n");
                                }
                                tVcam = new TVcam();
                                bl2 = true;
                                continue;
                            }
                            if (string.equals("name") && bl2) {
                                tVcam.setName(this.getStringNormal(string2.substring(n + 1, string2.length())));
                                continue;
                            }
                            if (string.equals("track") && bl2) {
                                tVcam.setTrack(this.getStringNormal(string2.substring(n + 1, string2.length())));
                                continue;
                            }
                            if (string.equals("type") && bl2) {
                                if (this.getStringNormal(string2.substring(n + 1, string2.length())).equals("point")) {
                                    tVcam.type = 0;
                                    continue;
                                }
                                if (!this.getStringNormal(string2.substring(n + 1, string2.length())).equals("line")) continue;
                                tVcam.type = 1;
                                continue;
                            }
                            if (string.equals("x") && bl2) {
                                tVcam.vecX = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("y") && bl2) {
                                tVcam.vecY = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("z") && bl2) {
                                tVcam.vecZ = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("startPointX") && bl2) {
                                tVcam.sX = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("startPointY") && bl2) {
                                tVcam.sY = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("startPointZ") && bl2) {
                                tVcam.sZ = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("endPointX") && bl2) {
                                tVcam.eX = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("endPointY") && bl2) {
                                tVcam.eY = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("endPointZ") && bl2) {
                                tVcam.eZ = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("linePositioning") && bl2) {
                                if (string2.substring(n + 1, string2.length()).equals("nearestPoint")) {
                                    tVcam.linePositioning = 0;
                                    continue;
                                }
                                if (!string2.substring(n + 1, string2.length()).equals("nodeProportional")) continue;
                                tVcam.linePositioning = 1;
                                continue;
                            }
                            if (string.equals("lineOffset") && bl2) {
                                tVcam.lineOffset = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("heading") && bl2) {
                                if (string2.substring(n + 1, string2.length()).equals("free")) {
                                    tVcam.headingFree = true;
                                    continue;
                                }
                                tVcam.heading = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                tVcam.headingFree = false;
                                continue;
                            }
                            if (string.equals("pitch") && bl2) {
                                if (string2.substring(n + 1, string2.length()).equals("free")) {
                                    tVcam.pitchFree = true;
                                    continue;
                                }
                                tVcam.pitchFree = false;
                                tVcam.pitch = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("roll") && bl2) {
                                if (string2.substring(n + 1, string2.length()).equals("free")) {
                                    tVcam.rollFree = true;
                                    continue;
                                }
                                tVcam.rollFree = false;
                                tVcam.roll = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("fov") && bl2) {
                                if (string2.substring(n + 1, string2.length()).equals("free")) {
                                    tVcam.fovFree = true;
                                    continue;
                                }
                                tVcam.fovFree = false;
                                tVcam.fov = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("areaDef") && bl2) {
                                if (string2.substring(n + 1, string2.length()).equals("area")) {
                                    tVcam.areaDef = 1;
                                    continue;
                                }
                                if (!string2.substring(n + 1, string2.length()).equals("node")) continue;
                                tVcam.areaDef = 0;
                                continue;
                            }
                            if (string.equals("startNode") && bl2) {
                                tVcam.startNode = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("stopNode") && bl2) {
                                tVcam.stopNode = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("Ax") && bl2) {
                                tVcam.Ax = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("Ay") && bl2) {
                                tVcam.Ay = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("Bx") && bl2) {
                                tVcam.Bx = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("By") && bl2) {
                                tVcam.By = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("Cx") && bl2) {
                                tVcam.Cx = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("Cy") && bl2) {
                                tVcam.Cy = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("Dx") && bl2) {
                                tVcam.Dx = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("Dy") && bl2) {
                                tVcam.Dy = this.getIntegerValue(string2.substring(n + 1, string2.length()));
                                continue;
                            }
                            if (string.equals("probability") && bl2) {
                                tVcam.setProbability(this.getIntegerValue(string2.substring(n + 1, string2.length())));
                                continue;
                            }
                            if (!string.equals("stopCam")) continue;
                            if (this.verifyCamera(tVcam)) {
                                if (tVcam.areaDef == 1) {
                                    tVcam.setPolygon();
                                }
                                tVcam.setSetName(fileArray[i].getName());
                                this.camLog.write("Adding camera " + fileArray2[j] + "\\" + tVcam.getName() + "\n");
                                this.addCam(tVcam);
                            } else {
                                this.camLog.write("Error while reading camera " + fileArray2[j] + "\\" + tVcam.getName() + "\n");
                            }
                            bl2 = false;
                        }
                        bufferedReader.close();
                    }
                }
            }
            this.camLog.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public int getIntegerValue(String string) {
        String string2 = string.replaceAll("[^0123456789.]", "");
        String[] stringArray = string.split("[.]");
        int n = Integer.valueOf(stringArray[0]);
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public String getStringNormal(String string) {
        if (string != null) {
            return string.replaceAll("[\\W]", "");
        }
        return "";
    }

    public TVcam[] getCams() {
        return cams;
    }

    public String[] getSetNames() {
        return this.cameraSets;
    }

    public void addCam(TVcam tVcam) {
        if (cams != null) {
            TVcam[] tVcamArray = cams;
            cams = new TVcam[tVcamArray.length + 1];
            for (int i = 0; i < tVcamArray.length; ++i) {
                TVParseCamFile.cams[i] = tVcamArray[i];
            }
            TVParseCamFile.cams[i] = tVcam;
        } else {
            cams = new TVcam[1];
            TVParseCamFile.cams[0] = tVcam;
        }
    }

    public boolean verifyCamera(TVcam tVcam) throws IOException {
        if (tVcam.getName() == null) {
            this.camLog.write("No name specified.\n");
            return false;
        }
        if (tVcam.getName().equals("")) {
            this.camLog.write("No name specified.\n");
            return false;
        }
        if (tVcam.getTrack() == null) {
            this.camLog.write("No track specified.\n");
            return false;
        }
        if (tVcam.getTrack().equals("")) {
            this.camLog.write("No track specified.\n");
            return false;
        }
        if (tVcam.type == -1) {
            this.camLog.write("Incorrect camera type definition. Must be 'point' or 'line'.\n");
            return false;
        }
        if (tVcam.type == 0) {
            if (tVcam.vecX == 0 || tVcam.vecY == 0 || tVcam.vecZ == 0) {
                this.camLog.write("Not all camera coordinates were defined (must be x, y, z).\n");
                return false;
            }
        } else if (tVcam.type == 1) {
            if (tVcam.sX == 0 || tVcam.sY == 0 || tVcam.sZ == 0 || tVcam.eX == 0 || tVcam.eY == 0 || tVcam.eZ == 0) {
                this.camLog.write("Not all camera coordinates were defined (must be startPointX, startPointY, startPointZ, endPointX, endPointY, endPointZ).\n");
                return false;
            }
            if (tVcam.linePositioning == -1) {
                this.camLog.write("Linepositioning not specified (must be 'nearestPoint' or 'nodeProportional').\n");
                return false;
            }
        } else {
            this.camLog.write("Line type not specified (must be 'point' or 'line').\n");
            return false;
        }
        if (tVcam.lineOffset > 0x140000) {
            tVcam.lineOffset = 0x140000;
        } else if (tVcam.lineOffset < -1310720) {
            tVcam.lineOffset = -1310720;
        }
        if (!tVcam.headingFree && tVcam.heading == 0) {
            this.camLog.write("Heading was not specified (must be 'free' or an integer value).\n");
            return false;
        }
        if (!tVcam.pitchFree && tVcam.pitch == 0) {
            this.camLog.write("Pitch was not specified (must be 'free' or an integer value).\n");
            return false;
        }
        if (!tVcam.rollFree && tVcam.roll == 0) {
            this.camLog.write("Roll was not specified (must be 'free' or an integer value).\n");
            return false;
        }
        if (!tVcam.fovFree && tVcam.fov == 0.0f) {
            this.camLog.write("FOV was not specified (must be 'free' or an integer value).\n");
            return false;
        }
        if (tVcam.areaDef == -1) {
            this.camLog.write("areaDef was not specified (must be 'area' or 'node').\n");
            return false;
        }
        if (tVcam.areaDef == 0) {
            if (tVcam.startNode == -1 || tVcam.stopNode == -1) {
                if (tVcam.startNode == -1) {
                    this.camLog.write("startNode was not specified (must be integer value).\n");
                }
                if (tVcam.stopNode == -1) {
                    this.camLog.write("stopNode was not specified (must be integer value).\n");
                }
                return false;
            }
        } else if (tVcam.areaDef == 1) {
            if (tVcam.Ax == 0 || tVcam.Ay == 0 || tVcam.Bx == 0 || tVcam.By == 0 || tVcam.Cx == 0 || tVcam.Cy == 0 || tVcam.Dx == 0 || tVcam.Dy == 0) {
                this.camLog.write("Not all area points were defined (must be Ax, Ay, Bx, By, Cx, Cy, Dx, Dy).\n");
                return false;
            }
        } else {
            this.camLog.write("areaDef was incorrectly defined (must be 'area' or 'node').\n");
            return false;
        }
        return true;
    }
}

