/*
 * Decompiled with CFR 0.152.
 */
public class TVgrid
extends TVcontrol {
    private TVteam[] teams;
    private int poleside;
    private final int oneMeterInLfs = 65536;
    private boolean isCleared = false;

    TVgrid(TVin tVin, TVout tVout) {
        super(tVin, tVout);
    }

    public void setTeams(TVteam[] tVteamArray) {
        this.teams = tVteamArray;
    }

    public void setPoleside(int n) {
        this.poleside = n;
    }

    public TVconnection getConnection(int n) throws TVException {
        TVconnection tVconnection;
        try {
            tVconnection = connections[this.getCurrentIndex(n)];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new TVException("uid not found");
        }
        return tVconnection;
    }

    public void checkGrid() {
        this.checkSpeed(80, 10, 10);
        this.checkOrder();
    }

    public void checkSpeed(int n, int n2, int n3) {
        for (int i = 0; i < connections.length; ++i) {
            connections[i].setGridSpeedOk(connections[i].getSpeed() > n - n3 && connections[i].getSpeed() < n + n2);
        }
    }

    public void checkOrder() {
        if (connections != null && connections.length > 0 && this.teams.length > 0) {
            int n;
            int n2;
            int[] nArray = new int[this.teams.length];
            for (n2 = 0; n2 < this.teams.length; ++n2) {
                nArray[n2] = -1;
            }
            for (n2 = 0; n2 < connections.length; ++n2) {
                for (n = 0; n < this.teams.length; ++n) {
                    if (!this.teams[n].isInTeam(connections[n2].getUserName())) continue;
                    nArray[n] = n2;
                }
            }
            n2 = 0;
            for (n2 = 0; n2 < nArray.length && nArray[n2] == -1; ++n2) {
            }
            if (n2 >= nArray.length) {
                return;
            }
            if (nArray[n2] == -1) {
                return;
            }
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == -1) continue;
                connections[nArray[n]].gridPos(this.teams[n].getGrid());
            }
            if (this.controlPanel.getControlMode() == 1 || this.controlPanel.getControlMode() == 2) {
                this.checkRED(nArray, n2);
            }
            this.checkSF(nArray);
        }
    }

    public void checkSF(int[] nArray) {
        int n;
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        int n3 = -1;
        int n4 = 999;
        boolean bl = false;
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = -2;
        }
        for (n = 0; n < Math.min(nArray.length, connections.length); ++n) {
            n3 = -1;
            n2 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) continue;
                bl = false;
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray2[j] != nArray[i]) continue;
                    bl = true;
                    break;
                }
                if (bl || TVgrid.connections[nArray[i]].node <= n2 || TVgrid.connections[nArray[i]].node > n4) continue;
                n2 = TVgrid.connections[nArray[i]].node;
                n3 = nArray[i];
            }
            if (n3 == -1) continue;
            n4 = n2;
            nArray2[n] = n3;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray2[n] <= -1 || nArray2[n] >= connections.length) continue;
            connections[nArray2[n]].sfPos(n + 1);
        }
    }

    public void checkRED(int[] nArray, int n) {
        int n2;
        double d = (double)TVgrid.connections[nArray[n]].heading / 32768.0 * Math.PI;
        double d2 = TVgrid.connections[nArray[n]].x;
        double d3 = TVgrid.connections[nArray[n]].y;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == -1) continue;
            double d4 = TVgrid.connections[nArray[n2]].x;
            double d5 = TVgrid.connections[nArray[n2]].y;
            connections[nArray[n2]].setGridX((int)(Math.cos(d) * (d4 - d2) + Math.sin(d) * (d5 - d3)));
            connections[nArray[n2]].setGridY((int)(-Math.sin(d) * (d4 - d2) + Math.cos(d) * (d5 - d3)));
        }
        n2 = 0x100000;
        int n3 = 196608;
        for (int i = 0; i < this.teams.length; ++i) {
            if (nArray[i] == -1) continue;
            int n4 = -(i / 2) * n2;
            connections[nArray[i]].setGridPosition(Math.abs(connections[nArray[i]].getGridY() - n4) < n3);
            connections[nArray[i]].gridUp(n4 - n3 > connections[nArray[i]].getGridY());
            connections[nArray[i]].gridDown(n4 + n3 < connections[nArray[i]].getGridY());
            if (i % 2 == 0) {
                if (i + 1 < nArray.length && nArray[i + 1] != -1) {
                    if (this.poleside == 0) {
                        if (connections[nArray[i]].getGridX() < connections[nArray[i + 1]].getGridX()) {
                            connections[nArray[i]].gridLeft(false);
                            connections[nArray[i]].gridRight(false);
                            continue;
                        }
                        connections[nArray[i]].gridLeft(true);
                        connections[nArray[i]].gridRight(false);
                        continue;
                    }
                    if (connections[nArray[i]].getGridX() > connections[nArray[i + 1]].getGridX()) {
                        connections[nArray[i]].gridLeft(false);
                        connections[nArray[i]].gridRight(false);
                        continue;
                    }
                    connections[nArray[i]].gridLeft(false);
                    connections[nArray[i]].gridRight(true);
                    continue;
                }
                connections[nArray[i]].gridLeft(false);
                connections[nArray[i]].gridRight(false);
                continue;
            }
            if (i - 1 > -1 && nArray[i - 1] != -1) {
                if (this.poleside == 0) {
                    if (connections[nArray[i]].getGridX() > connections[nArray[i - 1]].getGridX()) {
                        connections[nArray[i]].gridLeft(false);
                        connections[nArray[i]].gridRight(false);
                        continue;
                    }
                    connections[nArray[i]].gridLeft(false);
                    connections[nArray[i]].gridRight(true);
                    continue;
                }
                if (connections[nArray[i]].getGridX() < connections[nArray[i - 1]].getGridX()) {
                    connections[nArray[i]].gridLeft(false);
                    connections[nArray[i]].gridRight(false);
                    continue;
                }
                connections[nArray[i]].gridLeft(true);
                connections[nArray[i]].gridRight(false);
                continue;
            }
            connections[nArray[i]].gridLeft(false);
            connections[nArray[i]].gridRight(false);
        }
    }

    public void showHelper() {
        int n;
        int[] nArray = new int[this.teams.length];
        for (n = 0; n < this.teams.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < connections.length; ++n) {
            for (int i = 0; i < this.teams.length; ++i) {
                if (!this.teams[i].isInTeam(connections[n].getUserName())) continue;
                nArray[i] = n;
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == -1 || connections[nArray[n]].getUserName() == null || connections[nArray[n]].getUserName() == "") continue;
            String string = "";
            int n2 = this.controlPanel.getControlMode();
            if (n2 == 5) {
                if (!this.isCleared) {
                    this.sendMST("/rcc_all");
                    this.isCleared = true;
                }
            } else if (n2 == 0) {
                string = "^4SINGLE FILE - YOUR GRIDPOS: " + connections[nArray[n]].gridPos();
            } else if (n2 == 1) {
                string = "^5DOUBLE FILE - YOUR ROW: " + ((connections[nArray[n]].gridPos() - 1) / 2 + 1);
                if (this.poleside == 0 && (connections[nArray[n]].gridPos() - 1) % 2 == 0) {
                    string = string + " LEFT";
                }
                if (this.poleside == 1 && (connections[nArray[n]].gridPos() - 1) % 2 == 0) {
                    string = string + " RIGHT";
                }
                if (this.poleside == 0 && (connections[nArray[n]].gridPos() - 1) % 2 == 1) {
                    string = string + " RIGHT";
                }
                if (this.poleside == 1 && (connections[nArray[n]].gridPos() - 1) % 2 == 1) {
                    string = string + " LEFT";
                }
            } else if (n2 == 2) {
                string = connections[nArray[n]].gridLeft() ? "^7\uff8b" : "^0\uff8b";
                string = connections[nArray[n]].gridUp() ? string + "^7\uff8f" : string + "^0\uff8f";
                string = string + "^1\uff95\uff95\uff95\uff95\uff95";
                string = connections[nArray[n]].gridDown() ? string + "^7\uff90" : string + "^0\uff90";
                string = connections[nArray[n]].gridRight() ? string + "^7\uff9b" : string + "^0\uff9b";
            } else if (n2 == 3) {
                string = "^2\uff95\uff95\uff95\uff95\uff95";
            } else if (n2 == 4) {
                string = "^1ABORT\uff95\uff95\uff95\uff95\uff95START";
            }
            if (n2 == 5 || connections[nArray[n]].getSpectate()) continue;
            if (this.getViewPlayer() == TVgrid.connections[nArray[n]].playerNumber) {
                // empty if block
            }
            if (!string.equals(connections[nArray[n]].lastRCM())) {
                this.sendMST("/rcm " + string);
                this.sendMST("/rcm_ply " + connections[nArray[n]].getUserName());
                connections[nArray[n]].lastRCM(string);
            }
            this.isCleared = false;
        }
        for (n = 0; n < connections.length; ++n) {
            boolean bl = false;
            String string = "";
            int n3 = this.controlPanel.getControlMode();
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                bl = true;
            }
            if (bl || connections[n] == null) continue;
            if (n3 == 0) {
                string = "^4SINGLE FILE";
            } else if (n3 == 1) {
                string = "^5DOUBLE FILE";
            } else if (n3 == 2) {
                string = string + "^1\uff95\uff95\uff95\uff95\uff95";
            } else if (n3 == 3) {
                string = "^2\uff95\uff95\uff95\uff95\uff95";
            } else if (n3 == 4) {
                string = "^1ABORT\uff95\uff95\uff95\uff95\uff95START";
            }
            if (n3 == 5 || connections[n].getSpectate()) continue;
            if (!string.equals(connections[n].lastRCM())) {
                this.sendMST("/rcm " + string);
                this.sendMST("/rcm_ply " + connections[n].getUserName());
                connections[n].lastRCM(string);
            }
            this.isCleared = false;
        }
    }
}

