<?php
#################################################################
# mpres global.inc.php V2.10																		#
# used to determine what the script is supposed to do						#
# directory: script main path																		#
#################################################################
if (!defined('NORMAL_ACCESS')) {header("HTTP/1.1 404 File Not Found");echo "<h1>404 File Not Found</h1>";exit;}
$errors = null;
ini_set('max_execution_time' , 90);

### script version | do not change this! ###
define('MPRES_VERSION', '2.10');

### define paths of this script ###
define('DS', DIRECTORY_SEPARATOR);
define('SCRIPTPATH', dirname(realpath(__FILE__)).DS);
define('HTTPPATH', (pathinfo($_SERVER['PHP_SELF'], PATHINFO_DIRNAME) == DS) ? '/' : pathinfo($_SERVER['PHP_SELF'], PATHINFO_DIRNAME).'/');
define('SCRIPTURL', 'http://'.$_SERVER['SERVER_NAME'].HTTPPATH);

### include required files ###
require_once(SCRIPTPATH.'config.inc.php');
require_once(SCRIPTPATH.'includes/functions.php');
require_once(SCRIPTPATH.'includes/definitions.php');

### set factor for miles - km conversion ###
$distunit = (DISTUNIT=='km' || DISTUNIT=='mi') ? DISTUNIT : 'km';
$speedunit = ($distunit=='km') ? 'km/h' : 'mph';
$km2mifactor = ($distunit=='km') ? 1 : KM_2_MI;

### create legues/singles-arrays in case they weren't defined in config.inc ###
$events = getevents(SCRIPTPATH.'event_definitions.txt');
### save amount of different leagues/singles as constants for later use (lang-variables/menus) ###
define('NUM_LEAGUES', count($events['league']));
define('NUM_SINGLES', count($events['single']));

### choose language for output ###
# check if user has set a language cookie or has selected a language manually instead
foreach(glob(SCRIPTPATH.'lang/*.ini') as $langfile) $vlangs[] = basename($langfile, '.ini');
if(isset($_GET['lang']) && in_array($_GET['lang'], $vlangs)) $ulang = $_GET['lang'];
elseif(isset($_COOKIE['lang']) && in_array($_COOKIE['lang'], $vlangs)) $ulang = $_COOKIE['lang'];
else $ulang = null;
# load language variables
$lang = getlanguage(OUTLANG, $_SERVER['HTTP_ACCEPT_LANGUAGE'], $ulang);

### parse userinput/URL to determine event/replay to show ###
$types = array('league','single');
$gettype = (!empty($_GET['type']) && in_array($_GET['type'], $types)) ? $_GET['type'] : null;
$getevent = (isset($gettype) && !empty($_GET['event']) && array_key_exists($_GET['event'], $events[$gettype])) ? $_GET['event'] : null;
if(isset($getevent) && !empty($_GET['season']) && array_key_exists($_GET['season'], $events[$gettype][$getevent]['seasons'])) {
	$getseason = $_GET['season'];
	$istoc = $events[$gettype][$getevent]['seasons'][$getseason]['toc'];
}
else $getseason = null;
$getday = (isset($getseason) && !empty($_GET['day']) && ctype_digit($_GET['day'])) ? $_GET['day'] : null;
$getgrid = (isset($getseason) && !empty($_GET['grid']) && ctype_digit($_GET['grid'])) ? $_GET['grid'] : null;
$getsession = (isset($getseason) && !empty($_GET['session']) && ctype_alnum($_GET['session'])) ? $_GET['session'] : null;
# gridnumber and/or raceday/round are not set/used -> default to 0 (uncategorized)
if(isset($getsession) && isset($_GET['day']) && empty($_GET['day'])) $getday = 0;
if(isset($getsession) && isset($_GET['grid']) && empty($_GET['grid'])) $getgrid = 0;

### scan replay folders for replays that match the selected event ###
$files = array();
$filename = null;
$files = scan_files($gettype, $getevent);
### get maximum number of grids and/or rounds for the selected season (for menu and select screen) => 0 if not used ###
if(!empty($files[$gettype][$getevent]) && isset($getevent)) {
	foreach($files[$gettype][$getevent] as $sid => $season) {
		$maxgrids = 0;
		$maxdays = 0;
		if(!empty($season)) foreach($season as $did => $days) {
		if($did>$maxdays) $maxdays = $did;
		foreach($days as $gid=>$grid) {
				if($gid>$maxgrids) $maxgrids = $gid;
		}
		}
		$events[$gettype][$getevent]['seasons'][$sid]['maxgrids'] = $maxgrids;
		$events[$gettype][$getevent]['seasons'][$sid]['maxdays'] = $maxdays;
	}
}
### get file if chosen ###
$file = $files[$gettype][$getevent][$getseason][$getday][$getgrid][$getsession];
if(!empty($file)) $filename = basename($file);

### set savefile and replay-path if a replay is selected and found ###
if(!empty($filename)) {
	$basefilename = basename($filename, '.mpr');
	define('SAVEFILE', SCRIPTPATH.'saves'.DS.$gettype.'_'.$getevent.'_S'.$getseason.'_R'.$getday.'_G'.$getgrid.'_E'.$getsession.'.mprdata');
	define('REPLAYPATH', dirname(realpath(SCRIPTPATH.$file)).DS);
	### do the replay-parsing ###
	require_once(SCRIPTPATH.'includes/get_replays.php');
}
?>