<?php
#################################################################
# mpres initdata.php V2.10																			#
# parses the start of the replay (before the race)							#
# directory: /includes/readmpr																	#
#################################################################
if (!defined('NORMAL_ACCESS')) {header("HTTP/1.1 404 File Not Found");echo "<h1>404 File Not Found</h1>";exit;}

### read initial mpr data ###
do {
	$buff = unpack("@0/Clength/Ctype",fread($handle,2));
	$data = fread($handle,$buff['length']-1);
	switch($buff['type']) {
		case FP_CARSTATUS:	#car status
							$initstates[] = unpack($framepackets[FP_CARSTATUS],$data);
							break;
		case FP_CARSTATUS2:	#car status
							$initstates[] = unpack($framepackets[FP_CARSTATUS2],$data);
							break;
		case FP_RACEJOIN:	#racejoin
							$racejoins[] = unpack($framepackets[FP_RACEJOIN],$data);
							break;
		case FP_LEAVEPIT:	#leavepits
							$leavepits[] = unpack($framepackets[FP_LEAVEPIT],$data);
							break;
		case FP_INITCONN:	#init connections
							$initconnections[] = unpack($framepackets[FP_INITCONN],$data);
							break;
		case FP_RACEINIT:	#race start
							$racedata = unpack($framepackets[FP_RACEINIT],$data);
							$mprstart = unpack("@0/Vmprstarttime",fread($handle,4));
							$tfcycle = floor($mprstart['mprstarttime']/65535);
							$lasttf = $mprstart['mprstarttime'] % 65535;
							break;
		case FP_LAYOUT:	# layoutdata
							$haslayout = true;
							$objos = 3;
							while ($objos<=$buff['length']-9) {
								$objects[] = unpack("@".$objos.$framepackets[FP_LAYOUT],$data);
								$objos += 8;
							}
							break;
		case FP_QUALPREBEST:	#done qual laps
							break;
		case FP_PREDAMAGE:	#initial damage
							break;
		case FP_PRERACESTATE:	#initial race state
							break;
		case FP_LAYOUT2:	# new layoutdata from lfs 0.6k9
							$haslayout = true;
							$objos2 = 3;
							while ($objos2<=$buff['length']-9) {
								$objects[] = unpack("@".$objos2.$framepackets[FP_LAYOUT2],$data);
								$objos2 += 8;
							}
							break;
		default:	$errors[] = $lang['errors']['unknown_init_package'].' ('.str_pad(dechex($buff['type']), 2, "0", STR_PAD_LEFT).')';
	}
} while ($buff['type']!=FP_RACEINIT);

### get sectors from object-arrays if layout was loaded ###
if(is_array($objects) && $mprheader['mprversion']<18) {
	foreach($objects as $id=>$obj) {
		if($obj['index']==0 && $obj['flag']!=0) {
			if($obj['flag']!=128 && (($obj['flag'] & 131)==128)) $secpoints[] = 'finish';
			if(($obj['flag'] & 131)==129) $secpoints[] = 1;
			if(($obj['flag'] & 131)==130) $secpoints[] = 2;
			if(($obj['flag'] & 131)==131) $secpoints[] = 3;
		}
		else unset($objects[$id]);
	}
}
elseif(is_array($objects) && $mprheader['mprversion']>=18) {
	foreach($objects as $id=>$obj) {
		if($obj['index']==0 && $obj['flag']!=0) {
			if($obj['flag']!=0 && (($obj['flag'] & 3)==0)) $secpoints[] = 'finish';
			if(($obj['flag'] & 3)==1) $secpoints[] = 1;
			if(($obj['flag'] & 3)==2) $secpoints[] = 2;
			if(($obj['flag'] & 3)==3) $secpoints[] = 3;
		}
		else unset($objects[$id]);
	}
}
if($haslayout==true && is_array($secpoints)) {
	if(in_array('finish',$secpoints)) {
		$laysecs = 1;
		if(in_array(1,$secpoints)) {
			$laysecs++;
			if(in_array(2,$secpoints)) {
				$laysecs++;
				if(in_array(3,$secpoints))	$laysecs++;
			}
		}
	}
}
### get number of sectors for the track ###
$sectors = ($haslayout===true && !empty($laysecs)) ? $laysecs : $trackarray[$mprheader['trackname']][$mprheader['config']]['sectors'];

### adjust names on racejoins ###
if(!empty($racejoins)) foreach($racejoins as $id=>$data) {
	$racejoins[$id]['nick'] = codepage_convert(strtok($data['nick'],"\0"));
	$racejoins[$id]['plate'] = codepage_convert(strtok($data['plate'],"\0"));
}

### adjust names on initial connections ###
if(!empty($initconnections)) foreach($initconnections as $id=>$data) {
	$initconnections[$id]['lfsw'] = (!empty($data['lfsw'])) ? codepage_convert(strtolower(strtok($data['lfsw'],"\0"))) : 'demodummyname'.nameblank(codepage_convert(strtok($data['nick'],"\0")));
	$initconnections[$id]['nick'] = codepage_convert(strtok($data['nick'],"\0"));
	$initconnections[$id]['plate'] = codepage_convert(strtok($data['plate'],"\0"));
}

### determine length of race, type (hours of laps) and mode (race, qual or train) ###
switch($racedata['type']) {
# 0			: practice
# 1-99		: number of laps		laps  = rl
# 100-190	: 100 to 1000 laps	laps  = (rl - 100) * 10 + 100
# 191-238	: 1 to 48 hour			hours = rl - 190
	case SESSION_RACE:
		if(!empty($setduration) && $_GET['force_load']==FORCE_LOAD_PASS) $racedata['laphours'] = $setduration;
		if($racedata['laphours']==0) $racetype = RACETYPE_TRAINING;
		elseif($racedata['laphours']<191) {
			$duration = ($racedata['laphours'] - floor($racedata['laphours']/100)*100)*pow(10,floor($racedata['laphours']/100)) + floor($racedata['laphours']/100)*100;
			$racetype = RACETYPE_LAPS;
		}
		else {
			$duration = ($racedata['laphours']-190)*360000;
			$racetype = RACETYPE_TIME;
		}
		break;
	case SESSION_QUAL:
		$duration = $racedata['qualmins']*6000;
		$racetype = RACETYPE_QUAL;
		break;
}

### create player-, cars- and connection-arrays ###
$conns = array();
$plids = array();
$cars = array();
$stinplayers = array();
$players = array();
$stints = array();
foreach($initconnections as $id=>$data) {
	$players[$data['lfsw']]['connid'] = $id;
	$conns[$id]  = $data['lfsw'];
	$players[$data['lfsw']]['playerid'] = $data['playerid'];
	$plids[$data['playerid']]  = $data['lfsw'];
	$players[$data['lfsw']]['isadmin'] = ($data['isadmin']==1) ? true : false;
	$players[$data['lfsw']]['nick'] = $data['nick'];
	$players[$data['lfsw']]['plate'] = $data['plate'];
	$players[$data['lfsw']]['stints'] = array();
	$players[$data['lfsw']]['team'] = '';
	foreach($racejoins as $r=>$join) {
		if($join['connid']!=$id) continue;
		if($join['connid']==$id) {
			$cars[$join['carid']] = ($join['AI']==2 || $join['AI']==3) ? 'AIBOTdummyname'.$join['nick'] : $data['lfsw'];
			if($join['AI']==2 || $join['AI']==3) {
				$players[$cars[$join['carid']]]['nick'] = $join['nick'];
				$players[$cars[$join['carid']]]['plate'] = $join['plate'];
				$players[$cars[$join['carid']]]['stints'] = array();
				$players[$cars[$join['carid']]]['team'] = '';
			}
			$players[$cars[$join['carid']]]['pflags'] = $join['pflags'];
			$players[$cars[$join['carid']]]['initfuel'] = $join['initfuel'];
			$players[$cars[$join['carid']]]['pitfuel'] = $join['pitfuel'];
 			foreach($leavepits as $l=>$pits) {
				$pits['carname'] = strtok($pits['carname'],"\0");
				if($pits['carid']!=$join['carid']) continue;
				if($pits['carid']==$join['carid']) {
					if($istoc===true && $hasteams===true) {
						unset($tm);
						foreach($teams as $tid => $team) {
							if(in_array($cars[$join['carid']],$team['drivers']) && $team['car']==array_search($pits['carname'],$AllCars)) {
								$tm = $tid;
								break;
							}
							else continue;
						}
						if(empty($tm)) $errors[] = 'init: '.$lang['errors']['no_playerteam'].' ('.$cars[$join['carid']].' | '.nameblank($join['nick']).')';
					}
					else {
						$tm = 't'.$cars[$join['carid']];
						$teams[$tm]['car'] = array_search($pits['carname'],$AllCars);
						$teams[$tm]['drivers'][0] = $cars[$join['carid']];
						$teams[$tm]['name'] = $join['nick'];
					}
					$players_in_race++;
					$stnum = count($stints);
					$stints[$stnum]['connid'] = $id;
					$stints[$stnum]['playerid'] = $data['playerid'];
					$stints[$stnum]['nick'] = $join['nick'];
					$stints[$stnum]['plate'] = $join['plate'];
					$stints[$stnum]['lfsw'] = $cars[$join['carid']];
					$stints[$stnum]['pflags'] = $join['pflags'];
					$stints[$stnum]['carid'] = $join['carid'];
					$stints[$stnum]['carlaps'] = 0;
					$stints[$stnum]['initfuel'] = $join['initfuel'];
					$stints[$stnum]['pitfuel'] = $join['pitfuel'];
					$stints[$stnum]['carname'] = $pits['carname'];
					$stints[$stnum]['wasontrack'] = true;
					$stints[$stnum]['isontrack'] = true;
					$stints[$stnum]['leftpits'] = false;
					$stints[$stnum]['inrace'] = false;
					$stints[$stnum]['wasinrace'] = false;
					$stints[$stnum]['finished'] = false;
					$stints[$stnum]['lapsdone'] = 0;
					$stints[$stnum]['lastsplit'] = 0;
					$stints[$stnum]['lastsplittime'] = 0;
					$stints[$stnum]['sectimes'][1] = array();
					$stints[$stnum]['sectimes'][2] = array();
					$stints[$stnum]['sectimes'][3] = array();
					$stints[$stnum]['sectimes'][4] = array();
					$stints[$stnum]['sectimes']['lap'] = array();
					$stints[$stnum]['bestsectime'][1] = '';
					$stints[$stnum]['bestsectime'][2] = '';
					$stints[$stnum]['bestsectime'][3] = '';
					$stints[$stnum]['bestsectime'][4] = '';
					$stints[$stnum]['bestsectime']['lap'] = '';
					$stints[$stnum]['bestseclap'][1] = '';
					$stints[$stnum]['bestseclap'][2] = '';
					$stints[$stnum]['bestseclap'][3] = '';
					$stints[$stnum]['bestseclap'][4] = '';
					$stints[$stnum]['bestseclap']['lap'] = '';
					$stints[$stnum]['yellowflags'] = array();
					$stints[$stnum]['blueflags'] = array();
					$stints[$stnum]['pitstops'] = array();
					$stints[$stnum]['penalties'] = array();
					$stints[$stnum]['gospec'] = false;
					$stints[$stnum]['topit'] = false;
					$stints[$stnum]['reset'] = array();
					$stints[$stnum]['leftserver'] = false;
					$stints[$stnum]['rejoined'] = false;
					$stints[$stnum]['tocto'] = '';
					$stints[$stnum]['tocfrom'] = '';
					$stints[$stnum]['team'] = $tm;
					foreach($initstates as $state) {
						if($state['carid']==$pits['carid']) {
							$stints[$stnum]['initfuel'] = ($mprheader['mprversion']>=21) ? round($state['currfuel']/655.35,2) : round($state['currfuel']/2.55,2);
							$stints[$stnum]['currfuel'] = ($mprheader['mprversion']>=21) ? round($state['currfuel']/655.35,2) : round($state['currfuel']/2.55,2);
							$stints[$stnum]['engine'] = $state['engine'];
							$stints[$stnum]['clutch'] = $state['clutch'];
							if($mprheader['mprversion']<=20) {
								if($CarsDrive[array_search($stints[$stnum]['carname'], $AllCars)]==DRIVE_FRONT) {
									if($state['tRL'] == 2663050) $stints[$stnum]['tyreRear'] = 0;
									elseif($state['tRL'] == 4260880) $stints[$stnum]['tyreRear'] = 1;
									elseif($state['tRL'] == 5592405) $stints[$stnum]['tyreRear'] = 2;
									elseif($state['tRL'] == 6923930) $stints[$stnum]['tyreRear'] = 3;
									elseif($state['tRL'] == 1864135) $stints[$stnum]['tyreRear'] = 4;
									elseif($state['tRL'] == 1065220) $stints[$stnum]['tyreRear'] = 5;
									elseif($state['tRL'] == 0) $stints[$stnum]['tyreRear'] = 7;
									if($state['tFL'] == 2663050) $stints[$stnum]['tyreFront'] = 0;
									elseif($state['tFL'] == 4260880) $stints[$stnum]['tyreFront'] = 1;
									elseif($state['tFL'] == 5592405) $stints[$stnum]['tyreFront'] = 2;
									elseif($state['tFL'] == 6923930) $stints[$stnum]['tyreFront'] = 3;
									elseif($state['tFL'] == 1864135) $stints[$stnum]['tyreFront'] = 4;
									elseif($state['tFL'] == 1065220) $stints[$stnum]['tyreFront'] = 5;
									elseif($state['tFL'] == 0) $stints[$stnum]['tyreFront'] = 7;
								}
								elseif($CarsDrive[array_search( $stints[$stnum]['carname'],$AllCars)]==DRIVE_REAR || $CarsDrive[array_search( $stints[$stnum]['carname'],$AllCars)]==DRIVE_ALL) {
									if($state['tFL'] == 2663050) $stints[$stnum]['tyreRear'] = 0;
									elseif($state['tFL'] == 4260880) $stints[$stnum]['tyreRear'] = 1;
									elseif($state['tFL'] == 5592405) $stints[$stnum]['tyreRear'] = 2;
									elseif($state['tFL'] == 6923930) $stints[$stnum]['tyreRear'] = 3;
									elseif($state['tFL'] == 1864135) $stints[$stnum]['tyreRear'] = 4;
									elseif($state['tFL'] == 1065220) $stints[$stnum]['tyreRear'] = 5;
									elseif($state['tFL'] == 0) $stints[$stnum]['tyreRear'] = 7;
									if($state['tRL'] == 2663050) $stints[$stnum]['tyreFront'] = 0;
									elseif($state['tRL'] == 4260880) $stints[$stnum]['tyreFront'] = 1;
									elseif($state['tRL'] == 5592405) $stints[$stnum]['tyreFront'] = 2;
									elseif($state['tRL'] == 6923930) $stints[$stnum]['tyreFront'] = 3;
									elseif($state['tRL'] == 1864135) $stints[$stnum]['tyreFront'] = 4;
									elseif($state['tRL'] == 1065220) $stints[$stnum]['tyreFront'] = 5;
									elseif($state['tRL'] == 0) $stints[$stnum]['tyreFront'] = 7;
								}
							}
							else {
								if($CarsDrive21[array_search($stints[$stnum]['carname'], $AllCars)]==DRIVE_FRONT) {
									$stints[$stnum]['tyreRear'] = getTyreType($state['tFL']);
									$stints[$stnum]['tyreFront'] = getTyreType($state['tRL']);
								}
								elseif($CarsDrive21[array_search( $stints[$stnum]['carname'],$AllCars)]==DRIVE_REAR || $CarsDrive21[array_search( $stints[$stnum]['carname'],$AllCars)]==DRIVE_ALL) {
									$stints[$stnum]['tyreRear'] = getTyreType($state['tRL']);
									$stints[$stnum]['tyreFront'] = getTyreType($state['tFL']);
								}
							}
							$stints[$stnum]['initFront'] = $stints[$stnum]['tyreFront'];
							$stints[$stnum]['initRear'] = $stints[$stnum]['tyreRear'];
						}
					}
					$stintplayers[$cars[$join['carid']]] = $stnum;
					$players[$cars[$join['carid']]]['stints'][] = $stnum;
					$players[$cars[$join['carid']]]['team'] = $tm;
					$players[$cars[$join['carid']]]['teams'][$tm]['nick'] = $join['nick'];
					$players[$cars[$join['carid']]]['teams'][$tm]['plate'] = $join['plate'];
					$players[$cars[$join['carid']]]['teams'][$tm]['stints'][] = $stnum;
					$players[$cars[$join['carid']]]['teams'][$tm]['pflags'] = $join['pflags'];
					$teams[$tm]['stints'][] =$stnum;
					$teams[$tm]['startpos'] = $join['startpos'];
					$teams[$tm]['finished'] = false;
					if(($racetype!=RACETYPE_QUAL && $racetype!=RACETYPE_TRAINING) || $mprheader['mprversion']<11) $stints[$stnum]['wasinrace'] = true;
					if(($racetype!=RACETYPE_QUAL && $racetype!=RACETYPE_TRAINING) || $mprheader['mprversion']<11) $teams[$tm]['wasinrace'] = true;
					if(($racetype!=RACETYPE_QUAL && $racetype!=RACETYPE_TRAINING) || $mprheader['mprversion']<11) $players[$data['lfsw']]['wasinrace'] = true;
					if(($racetype!=RACETYPE_QUAL && $racetype!=RACETYPE_TRAINING) || $mprheader['mprversion']<11) $stints[$stnum]['inrace'] = true;
					if(($racetype!=RACETYPE_QUAL && $racetype!=RACETYPE_TRAINING) || $mprheader['mprversion']<11) $stints[$stnum]['leftpits'] = true;
				}
			}
		}
	}
}
?>