# Creating your own HTML pages (with php), for the PRISM webserver.
PRISM comes with its own webserver that you can activate. By default this will serve PRISM admin pages, for remote access via a browser.
If you would like to adjust these pages, or create your own, you can. You will find all the default php files that generate the admin pages in your www folder PRISM/www-docs by default. When you look at these php files you will notice they look pretty much like regular php files on a webserver. There are a few restrictions and differences however.


## Restrictions(1) - function and class declarations.
The PRISM webserver is itself written in PHP and because the php files served
from there are generated by the same instance of PHP, all the classes and
functions that you declare will remain resident after PRISM is done with your
page generation.

Let's take an example :
You have made a test file called wwwtest.php which you have put in the www-docs
folder. In it you declare a function and then trigger the function.

```php
function testFunction()
{
	return 'We have liftoff';
}

echo testFunction().PHP_EOL;
```

The first time this php file is executed, php will internally declare your
function testFunction() and then it is called. Page generation is done and the
PRISM webserver returns the result to your browser. But then you load the page
again. Once more php will internally declare testFunction(), but this time it
throws you a fatal error, because that function already exists. PRISM exits.

To get around this problem, you must put all your classes and functions inside
separate files. Then to use them in your script, you have to use require_once()
or include_once(). That way your functions and classes will only be declared
once and php will not complain.
This does mean that if you make a change to any of these included files, you
must restart PRISM in order for them to be loaded again.

NAMING CONVENTIONS - take special care when naming your functions and classes.
Don't give them overly simple names, or names that _might_ be used by others.
Remember, your functions and classes must live in the same space as the rest
of PRISM, including plugin functions and classes made by other people. You can
try to make use of namespaces though; I haven't tried this yet so I don't know
if it will work.


## Restrictions(2) - not all standard php functionalities can be used.
There are a number of standard php functions and functionalities that cannot be
used in your php files for the PRISM webserver. For example setcookie() will
not have the desired effect. setcookie() can only be used in real webserver
environments like the apache module or fastcgi. There is an alternative method
available to set cookies though - more about that below in the 'special PRISM
web server functions'. Another example are the output buffering functions. The
PRISM webserver has to make use of the ob_start(), ob_get_contents() and
ob_end_clean() functions for proper script parsing, so these can no longer be
used by your php script for PRISM.
See APPENDIX (A) for a list of functions that cannot be used.


## Special PRISM web server functions.
Because the PRISM web server isn't like a normal web server, some things had to
be done a little differently than you're used to when programming for web
applications. Because some regular php functions cannot be used, I had to
provide alternatives.
For example, the setcookie() function doesn't work as described earlier. And
it's the same with the header() function. As you may start to expect, all
regular php functions that affect the HTTP output headers cannot be used. I
have therefore introduced a new object that you can use for these purposes :
the $_RESPONSE object, where header related things can be set in the usual way.
See APPENDIX (B) for a list of extra functions provided by PRISM.


## The $_SESSION variable
I also have to mention the $_SESSION variable. Normally you have to do
session_start() before you can use $_SESSION, but here you can just start
manipulating $_SESSION straight away. This variable will already exist if you
are in a session. Otherwise you just create it and the variables in $_SESSION
will continue to live beyond the current http request. Later requests will
automatically have their session detected via a cookie and PRISM will fetch the
session data for you, in the shape of $_SESSION. If you want to clear a session,
just do unset($_SESSION);
One of the things you cannot do with regular php sessions, but you can with
PRISM sessions, is write resources to it. Sessions stay in PRISM's memory after
a http request and because all requests are served from the same php instance,
you can store for example a file handle in $_SESSION and it will be there upon
the next http request.
You can store a single variable in $_SESSION, or a huge, deeply recursive array.
It is of course up to you to make sure it will not slow PRISM too much, and / or
use too many resources (memory basically).


## APPENDIX (A) - list of standard php function(alitie)s you must not use.

**header()**

* see $_RESPONSE in APPENDIX (B)


**setcookie()**

* see $_RESPONSE in APPENDIX (B)

**all output buffering functions**

**all session functions**

* just write (or unset) straight to $_SESSIONS instead

**$_SERVER**

* you can use this, but it contains the php-cli variables, not http ones
* use $SERVER instead (see APPENDIX (B))

**$_REQUEST**

* just use the individual ones instead ($_GET $_POST $_COOKIE)


## APPENDIX (B) - list of extra function(alitie)s provided by PRISM.
**$_RESPONSE**

* ->setCookie(*same as setcookie()*)
* ->addHeader(string $header)
* ->setResponseCode(int $number)

**$SERVER**

* contains (almost) all the http headers you'd expect in a web environment

**$PRISM**

* this can be globalled in your functions, for easy access to PRISM content
* $PRISM->config	(handler for global PRISM config variables)
* $PRISM->hosts		(handler for the host connections)
* $PRISM->http		(handler for the web server)
* $PRISM->plugins	(handler for plugins)
* $PRISM->admins	(handler for admin accounts)

**Good luck!**
