#include "StdAfx.h"
#include ".\myownstuff.h"
#include "wsck.h"
#include "stdio.h"
#include "ini.h"
#define grav 9.8


CmyOwnStuff::CmyOwnStuff(IDirect3DDevice8 *pD3DDevice)
{
	extern HINSTANCE gl_hThisInstance;
		
	m_pD3DDevice = pD3DDevice;

	m_pBackgroundSprite  = NULL;
	D3DXCreateSprite(m_pD3DDevice,&m_pBackgroundSprite);

	//Load textures
	D3DXCreateTextureFromFile(m_pD3DDevice,"drift\\dgauge.dds",&m_pBackgroundTexture);
	D3DXCreateTextureFromFile(m_pD3DDevice,"drift\\dneedle.dds",&m_pNeedleTexture);
	D3DXCreateTextureFromFile(m_pD3DDevice,"drift\\ggauge.dds",&m_pGTexture);
	D3DXCreateTextureFromFile(m_pD3DDevice,"drift\\gdot.dds",&m_pDotTexture);

	//Set ports
	iPort = 1000;
	aPort = 20000;
	
	//Start winsock
	SckStartUp();

	//Get path
	char	*pStr, strPath[255];
	GetModuleFileName (NULL, strPath, 255);
	pStr = strrchr(strPath, '\\');
	if (pStr != NULL)
	    *(++pStr)='\0'; 

	sprintf(strMySystemFile,"%s%s",strPath, "drift.ini");


	//Load INI
	if (ReadFromFile("MAIN", "Version"))
	{
		version = atoi(ReadFromFile("MAIN", "Version"));
		if (version == 1)
		{
			char test2[255];
			fBack = strtoul(ReadFromFile("MAIN", "Font_Back_Color"),(char**) NULL, 16);
			fFront = strtoul(ReadFromFile("MAIN", "Font_Fore_Color"),(char**) NULL, 16);
			strcpy(fontname, ReadFromFile("MAIN", "Font_Name"));

			dB = atoi(ReadFromFile("MAIN", "Drift_Enabled"));
			dTB = atoi(ReadFromFile("MAIN", "Drift_Text_Enabled"));
			dBack = strtoul(ReadFromFile("MAIN", "Drift_Back_Color"),(char**) NULL, 16);
			dNeedle = strtoul(ReadFromFile("MAIN", "Drift_Needle_Color"),(char**) NULL, 16);
			dX = atof(ReadFromFile("MAIN", "Drift_Pos_X"));
			dY = atof(ReadFromFile("MAIN", "Drift_Pos_Y"));
			drW = atof(ReadFromFile("MAIN", "Drift_Width_Scale"));
			drH = atof(ReadFromFile("MAIN", "Drift_Height_Scale"));

			gB = atoi(ReadFromFile("MAIN", "GMeter_Enabled"));
			gTB = atoi(ReadFromFile("MAIN", "GMeter_Text_Enabled"));
			gScale = atof(ReadFromFile("MAIN", "GMeter_Multiplier"));
			gBack = strtoul(ReadFromFile("MAIN", "GMeter_Back_Color"),(char**) NULL, 16);
			gDot = strtoul(ReadFromFile("MAIN", "GMeter_Dot_Color"),(char**) NULL, 16);
			gX = atof(ReadFromFile("MAIN", "GMeter_Pos_X"));
			gY = atof(ReadFromFile("MAIN", "GMeter_Pos_Y"));
			grW = atof(ReadFromFile("MAIN", "GMeter_Width_Scale"));
			grH = atof(ReadFromFile("MAIN", "GMeter_Height_Scale"));
		}
	}
	
	
}

CmyOwnStuff::~CmyOwnStuff(void)
{
	if (m_pBackgroundSprite) m_pBackgroundSprite->Release();
	if (m_pBackgroundTexture) m_pBackgroundTexture->Release();
	if (m_pNeedleTexture) m_pNeedleTexture->Release();
	if (m_pGTexture) m_pGTexture->Release();
	if (m_pDotTexture) m_pDotTexture->Release();
	
	SckShutdown();
}

void CmyOwnStuff::Render(void)
{
	//Get UDP data
	Recv();

	//Have we received a message lately?
	if (GetTickCount() - lastmsg > 1000) return;

	//Get window size
	m_pD3DDevice->GetViewport(&vp);

	//Check for auto-scaling
	if (drW == -1) dW = vp.Width / 1280.0f; else dW = drW;
	if (drH == -1) dH = vp.Height / 1024.0f; else dH = drH;
	if (grW == -1) gW = vp.Width / 1280.0f; else gW = grW;
	if (grH == -1) gH = vp.Height / 1024.0f; else gH = grH;

	//Set positions
	bpos.x = float(vp.Width / 100.0f) * dX;
	bpos.y = float(vp.Height / 100.0f) * dY;

	npos.x = bpos.x + (128.0f * dW);
	npos.y = bpos.y + (120.0f * dH);

	gpos.x = float(vp.Width / 100.0f) * gX;
	gpos.y = float(vp.Height / 100.0f) * gY;



	//Normalize the speed vector
	D3DXVec3Normalize(&angle, &D3DXVECTOR3(mot.gsSpeedX, mot.gsSpeedY, mot.gsSpeedZ));
	
	//Create the matrix
	D3DXMatrixRotationYawPitchRoll(&mat, mot.gsRotZ, mot.gsRotY, mot.gsRotX);
	
	//Orient G vector
	g.x = ((mot.gsAccelX * mat._11 + mot.gsAccelY * mat._12 + mot.gsAccelZ * mat._13) * gScale);
	g.y = ((mot.gsAccelX * mat._21 + mot.gsAccelY * mat._22 + mot.gsAccelZ * mat._23) * gScale);
	
	//Orient speed vector
	vel.y = ((mot.gsSpeedX * mat._21 + mot.gsSpeedY * mat._22 + mot.gsSpeedZ * mat._23));

	//Get drift angle
    D3DXVec3Subtract(&test, &angle,&D3DXVECTOR3(mat._21, mat._22, mat._23));

	//Orient drift vector
	test.y = (test.x * mat._21 + test.y * mat._22 + test.z * mat._23) * 2;

	//Check G-Meter limits
	if (g.x > (56 * gW)) g.x = (56 * gW);
	if (g.x < (-56 * gW)) g.x = (-56 * gW);
	if (g.y > (56 * gH)) g.y = (56 * gH);
	if (g.y < (-56 * gH)) g.y = (-56 * gH);
	dpos.x = gpos.x + (56 * gW) + (-g.x * gW);
	dpos.y = gpos.y + (56 * gH) + (g.y * gH);

	//Is greater than 90?
	if (fabs(test.y) > (D3DX_PI / 2))
	{
		test.y = 0;
	}


	//Is going forward?
	if (vel.y > 1)
	{
		sprintf(out, "%-2.00f\0", fabs(test.y) * (180 / D3DX_PI));
		driftang = (180 * (D3DX_PI / 180)) - fabs(test.y);

	}
	else
	{
		sprintf(out, "%-2.00f\0");
		driftang = (180 * (D3DX_PI / 180));
	}




	//Begin this scene	
	m_pD3DDevice->BeginScene();


	//Draw textures
	m_pBackgroundSprite->Begin();
	if (dB)
	{
		float tester = -((driftang - D3DX_PI) * (dH - dW));
		m_pBackgroundSprite->Draw(m_pBackgroundTexture, NULL, &D3DXVECTOR2(dW, dH), NULL, NULL, &bpos, dBack);
		m_pBackgroundSprite->Draw(m_pNeedleTexture, NULL, &D3DXVECTOR2(dW + tester, dH + -tester), &D3DXVECTOR2(0, 8 * dH), driftang, &npos, dNeedle);

	}
	if (gB)
	{
		
		m_pBackgroundSprite->Draw(m_pGTexture, NULL, &D3DXVECTOR2(gW, gH), NULL, NULL, &gpos, gBack);
		m_pBackgroundSprite->Draw(m_pDotTexture, NULL, &D3DXVECTOR2(gW, gH), &D3DXVECTOR2(8 * gW, 8 * gH), NULL, &dpos, gDot);
	}
	m_pBackgroundSprite->End();



	//Draw drift degree text
	ar.top = bpos.y + (40 * dH);
	ar.left = bpos.x;
	ar.bottom = ar.top + 130 * dH;
	ar.right = ar.left + 130 * dW;
	
	//Make a font
    h_font = CreateFont( 40.0f * dH, 20.0f * dW, 0, 0,0, 0, 0, 0,DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH | FF_DONTCARE, TEXT(fontname));
	D3DXCreateFont(m_pD3DDevice, h_font, &m_font);


	if (dTB)
	{
		


		m_font->Begin();
		//Draw background first
		m_font->DrawTextA(out,-1,&ar,0,fBack);

		//Then foreground
		ar.top = ar.top - 1 * dH;
		ar.left = ar.left - 1 * dW;
		m_font->DrawTextA(out,-1,&ar,0,fFront);
		m_font->End();
	}

	m_font->Release();
	DeleteObject(h_font);

	h_font = CreateFont( 20.0f * dH, 12.0f * dW, 0, 0,0, 0, 0, 0,DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH | FF_DONTCARE, TEXT(fontname));
	D3DXCreateFont(m_pD3DDevice, h_font, &m_font);

	if (gTB)
	{
		ar.top = gpos.y - (50 * dH);
		ar.left = gpos.x;
		ar.bottom = ar.top + 130 * dH;
		ar.right = ar.left + 130 * dW;
		
		m_font->Begin();
		sprintf(out, "Lat  %+.02fg\nLong %+.02fg\0", (g.x * (9.8*0.01))*0.5,  (g.y * (9.8*0.01))*0.5);
		m_font->DrawTextA(out,-1,&ar,0,fBack);

		ar.top = ar.top - 1 * dH;
		ar.left = ar.left - 1 * dW;
		m_font->DrawTextA(out,-1,&ar,0,fFront);
		m_font->End();
	}


	//Clean up fonts
	m_font->Release();
	DeleteObject(h_font);


	//End this scene
	m_pD3DDevice->EndScene();

	
}

void CmyOwnStuff::OnLostDevice(void)
{
	m_pBackgroundSprite->OnLostDevice();

}

void CmyOwnStuff::OnResetDevice(void)
{

	m_pBackgroundSprite->OnResetDevice();

}

