Imports System.Net
Imports System.Net.Sockets
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Threading

Module modDataArrival

    'ACK string for packet id
    Public Const ACK = "ACK"

    '************ Receive: VER - InSimVersion ************'
    Public Sub arrivalVER(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rVER)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rVER = Marshal.PtrToStructure(Pointer, rVER.GetType())
        Marshal.FreeHGlobal(Pointer)

        Console.WriteLine("Server is running " & rVER.Product & " " & rVER.Version & " and InSim version " & rVER.InSimVer)
        If rVER.InSimVer <> 2 Then Console.WriteLine("WARNING: InSim version might be incompatible with this client")
    End Sub

    '************ Receive: ACK - Acknowledge ************'
    Public Sub arrivalACK()
        'Dont do anything, sending ACK's back is handled by AckTimer
    End Sub

    '************ Receive: STA - StatePack ************'
    Public Sub arrivalSTA(ByVal Bytes() As Byte)
        Static Dim OldTrack As String = ""

        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rSTA)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rSTA = Marshal.PtrToStructure(Pointer, rSTA.GetType())
        Marshal.FreeHGlobal(Pointer)

    End Sub

    '************ Receive: MSO - MsgOutPack ************'
    Public Sub arrivalMSO(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rMSO)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rMSO = Marshal.PtrToStructure(Pointer, rMSO.GetType())
        Marshal.FreeHGlobal(Pointer)

        ''''''''''''''''''''''''''' EXAMPLE OF HOW TO HANDLE INCOMING DATA '''''''''''''''''''''''''''
        ''''''''''''''''''''''''''' EXAMPLE OF HOW TO HANDLE INCOMING DATA '''''''''''''''''''''''''''
        rMSO.Msg = CleanString(rMSO.Msg)
        Console.WriteLine(rMSO.Msg)
        ''''''''''''''''''''''''''' EXAMPLE OF HOW TO HANDLE INCOMING DATA '''''''''''''''''''''''''''
        ''''''''''''''''''''''''''' EXAMPLE OF HOW TO HANDLE INCOMING DATA '''''''''''''''''''''''''''
    End Sub

    '************ Receive: MSS - MsgOutSplit ************'
    Public Sub arrivalMSS(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rMSS)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rMSS = Marshal.PtrToStructure(Pointer, rMSS.GetType())
        Marshal.FreeHGlobal(Pointer)

        ''''''''''''''''''''''''''' EXAMPLE OF HOW TO HANDLE INCOMING DATA '''''''''''''''''''''''''''
        ''''''''''''''''''''''''''' EXAMPLE OF HOW TO HANDLE INCOMING DATA '''''''''''''''''''''''''''
        rMSS.Msg = CleanString(rMSS.Msg)
        rMSS.PName = CleanString(rMSS.PName)
        Console.WriteLine(rMSS.PName & " : " & rMSS.Msg)
        ''''''''''''''''''''''''''' EXAMPLE OF HOW TO HANDLE INCOMING DATA '''''''''''''''''''''''''''
        ''''''''''''''''''''''''''' EXAMPLE OF HOW TO HANDLE INCOMING DATA '''''''''''''''''''''''''''
    End Sub

    '************ Receive: ISM - InSimMulti ************'
    Public Sub arrivalISM(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rISM)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rISM = Marshal.PtrToStructure(Pointer, rISM.GetType())
        Marshal.FreeHGlobal(Pointer)
    End Sub

    '************ Receive: VTN - InSimVote ************'
    Public Sub arrivalVTN(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rVTN)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rVTN = Marshal.PtrToStructure(Pointer, rVTN.GetType())
        Marshal.FreeHGlobal(Pointer)
    End Sub

    '************ Receive: VTC - Vote Canceled ************'
    Public Sub arrivalVTC()
        'No value here, just VTC.
    End Sub

    '************ Receive: VTA - Vote Action ************'
    Public Sub arrivalVTA(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rVTA)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rVTA = Marshal.PtrToStructure(Pointer, rVTA.GetType())
        Marshal.FreeHGlobal(Pointer)
    End Sub

    '************ Receive: RST - Race Start ************'
    Public Sub arrivalRST(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rRST)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rRST = Marshal.PtrToStructure(Pointer, rRST.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rRST.VerifyId)
    End Sub

    '************ Receive: REN - Race End ************'
    Public Sub arrivalREN(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rREN)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rREN = Marshal.PtrToStructure(Pointer, rREN.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rREN.VerifyId)
    End Sub

    '************ Receive: NCN - New Connection ************'
    Public Sub arrivalNCN(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rNCN)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rNCN = Marshal.PtrToStructure(Pointer, rNCN.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rNCN.VerifyId)
    End Sub

    '************ Receive: CNL - Connection Leave ************'
    Public Sub arrivalCNL(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rCNL)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rCNL = Marshal.PtrToStructure(Pointer, rCNL.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rCNL.VerifyId)
    End Sub

    '************ Receive: NPL - New PLayer joining race (if number already exists, then leaving pits) ************'
    Public Sub arrivalNPL(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rNPL)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rNPL = Marshal.PtrToStructure(Pointer, rNPL.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rNPL.VerifyId)
    End Sub

    '************ Receive: PLP - Player Pits ************'
    Public Sub arrivalPLP(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rPLP)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rPLP = Marshal.PtrToStructure(Pointer, rPLP.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rPLP.VerifyId)
    End Sub

    '************ Receive: PLL - Player Leave race ************'
    Public Sub arrivalPLL(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rPLL)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rPLL = Marshal.PtrToStructure(Pointer, rPLL.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rPLL.VerifyId)
    End Sub

    '************ Receive: CPR - Conn Player Rename ************'
    Public Sub arrivalCPR(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rCPR)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rCPR = Marshal.PtrToStructure(Pointer, rCPR.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rCPR.VerifyId)
    End Sub

    '************ Receive: CLR - Clear Race ************'
    Public Sub arrivalCLR(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rCLR)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rCLR = Marshal.PtrToStructure(Pointer, rCLR.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rCLR.VerifyId)
    End Sub

    '************ Receive: LAP - Lap Time ************'
    Public Sub arrivalLAP(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rLAP)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rLAP = Marshal.PtrToStructure(Pointer, rLAP.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rLAP.VerifyId)
    End Sub

    '************ Receive: SP1 - Split 1 Time ************'
    Public Sub arrivalSP1(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rSP1)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rSP1 = Marshal.PtrToStructure(Pointer, rSP1.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rSP1.VerifyId)
    End Sub

    '************ Receive: SP2 - Split 2 Time ************'
    Public Sub arrivalSP2(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rSP2)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rSP2 = Marshal.PtrToStructure(Pointer, rSP2.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rSP2.VerifyId)
    End Sub

    '************ Receive: SP3 - Split 3 Time ************'
    Public Sub arrivalSP3(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rSP3)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rSP3 = Marshal.PtrToStructure(Pointer, rSP3.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rSP3.VerifyId)
    End Sub

    '************ Receive: RES - Result ************'
    Public Sub arrivalRES(ByVal Bytes() As Byte)
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rRES)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rRES = Marshal.PtrToStructure(Pointer, rRES.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rRES.VerifyId)
    End Sub

    '************ Receive: REO - Reorder ************'
    Public Sub arrivalREO(ByVal Bytes() As Byte)
        'Convert received byte array to a structure

        Dim len As Integer = Marshal.SizeOf(rREO)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rREO = Marshal.PtrToStructure(Pointer, rREO.GetType())
        Marshal.FreeHGlobal(Pointer)

        'Send back the verify id
        Send.ISP(ACK, rREO.VerifyId)
    End Sub

    '************ Receive: MCI - MultiCarInfo ************'
    Public Sub arrivalMCI(ByVal Bytes() As Byte)
        ' useStruct()
        'Convert received byte array to a structure
        Dim len As Integer = Marshal.SizeOf(rMCI)
        Dim Pointer As IntPtr = Marshal.AllocHGlobal(len)
        Marshal.Copy(Bytes, 0, Pointer, len)
        rMCI = Marshal.PtrToStructure(Pointer, rMCI.GetType())
        Marshal.FreeHGlobal(Pointer)
    End Sub

    Public Sub Listen()

        Try
            'Initialize listen socket
            Dim listener As New UdpClient(cfg.LocalPort)
            Dim groupEP As New IPEndPoint(IPAddress.Any, cfg.LocalPort)
            Static Dim bExit As Boolean = False

            'Wait until data arrives
            While Not bExit
                Dim Bytes As Byte() = listener.Receive(groupEP)
                cfg.ACKTimer = 0

                cfg.Connected = True
                If Mid(Encoding.ASCII.GetString(Bytes), 5, 10) = "InSimClose" Then cfg.Connected = False

                'Get the packet Id
                Dim PackId As String = Left(Encoding.ASCII.GetString(Bytes, 0, Bytes.Length), 3)

                Select Case PackId
                    Case "VER" : arrivalVER(Bytes)
                    Case "ACK" : arrivalACK()
                    Case "STA" : arrivalSTA(Bytes)
                    Case "MSO" : arrivalMSO(Bytes)
                    Case "MSS" : arrivalMSS(Bytes)
                    Case "ISM" : arrivalISM(Bytes)
                    Case "VTN" : arrivalVTN(Bytes)
                    Case "VTC" : arrivalVTC()
                    Case "VTA" : arrivalVTA(Bytes)
                    Case "RST" : arrivalRST(Bytes)
                    Case "REN" : arrivalREN(Bytes)
                    Case "NCN" : arrivalNCN(Bytes)
                    Case "CNL" : arrivalCNL(Bytes)
                    Case "NPL" : arrivalNPL(Bytes)
                    Case "PLP" : arrivalPLP(Bytes)
                    Case "PLL" : arrivalPLL(Bytes)
                    Case "CPR" : arrivalCPR(Bytes)
                    Case "CLR" : arrivalCLR(Bytes)
                    Case "LAP" : arrivalLAP(Bytes)
                    Case "SP1" : arrivalSP1(Bytes)
                    Case "SP2" : arrivalSP2(Bytes)
                    Case "SP3" : arrivalSP3(Bytes)
                    Case "RES" : arrivalRES(Bytes)
                        ' Case "MCI" : arrivalMCI(Bytes)
                        ' Case "REO" : arrivalREO(Bytes)
                    Case Else
                        Console.WriteLine("WARNING: Unhandled packet with ID " & PackId)
                End Select
            End While

            'Catch any exceptions
        Catch ex As SocketException
            If ex.ErrorCode = 10048 Then
                Console.WriteLine("Socket bind failed, port " & cfg.LocalPort & " is already in use.")
                Console.WriteLine("Try changing the LocalPort setting in the config file.")
            Else
                Console.WriteLine("Unknown Socket error(" & ex.ErrorCode & ")")
            End If
        Catch ex As Exception
            Console.WriteLine(ex.Message())
        End Try

    End Sub


End Module