Imports System.Net
Imports System.Net.Sockets
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Threading

Public Class Send

    'sISI.Flags bytes
    Enum ISF
        ISF_RACE_TRACKING = 1       ' bit 0 : turns on race tracking
        ISF_GUARANTEE = 2           ' bit 1 : turns on guaranteed delivery
        ISF_SPLIT_MESSAGE = 4       ' bit 2 : use MSS, not MSO for user messages
        ISF_NO_WARNINGS = 8         ' bit 3 : turns off packet warnings
        ISF_KEEP_ALIVE = 16         ' bit 4 : makes lfs send keep alive packets
        ISF_NLP_MCI = 32            ' bit 5 : makes lfs send MCI instead of NLP
    End Enum

    '************ SendData Sub ************'
    Private Shared Sub SendData(ByVal Data() As Byte, Optional ByVal CMDline As String = Nothing)
        'Initialize udp socket
        Dim s As New Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp)
        Dim EndPoint As New IPEndPoint(cfg.IPAddress, cfg.RemotePort)

        'Send the actual data
        s.SendTo(Data, EndPoint)
        cfg.ACKIdleTimer = 0

        'Display message in the console
        If Not CMDline = Nothing Then Console.WriteLine(CMDline)
    End Sub

    '************ Send: ISI - InSimInit ************'
    Public Shared Sub ISI(ByVal Port As UShort, ByVal Flags As ISF, ByVal NodeSecs As Byte, ByVal Admin As String)
        'Set packet data
        sISI.Flags = Flags
        sISI.NodeSecs = NodeSecs
        sISI.Port = Port
        sISI.Admin = Admin
        sISI.Id = "ISI"

        'Holds the bytes we are going to send
        Dim ByteArray() As Byte

        'Converts the structure to the byte array
        Dim Ptr As IntPtr = Marshal.AllocHGlobal(Marshal.SizeOf(sISI))
        ReDim ByteArray(Marshal.SizeOf(sISI) - 1)
        Marshal.StructureToPtr(sISI, Ptr, False)
        Marshal.Copy(Ptr, ByteArray, 0, Marshal.SizeOf(sISI))
        Marshal.FreeHGlobal(Ptr)

        'Send data
        SendData(ByteArray, "Initializing InSim...")
    End Sub

    '************ Send: ISP - InSimPack ************'
    Public Shared Sub ISP(ByVal PacketId As String, Optional ByVal Value As Integer = 0, Optional ByVal CMDline As String = vbNullString)
        'Set packet data
        sISP.Id = PacketId
        sISP.Value = Value

        'Holds the bytes we are going to send
        Dim ByteArray() As Byte

        'Converts the structure to the byte array
        Dim Ptr As IntPtr = Marshal.AllocHGlobal(Marshal.SizeOf(sISP))
        ReDim ByteArray(Marshal.SizeOf(sISP) - 1)
        Marshal.StructureToPtr(sISP, Ptr, False)
        Marshal.Copy(Ptr, ByteArray, 0, Marshal.SizeOf(sISP))
        Marshal.FreeHGlobal(Ptr)

        'Send data
        SendData(ByteArray, CMDline)
    End Sub

    '************ Send: MST - MsgTypePack ************'
    Public Shared Sub MST(ByVal Message As String)
        'Set packet data
        sMST.Id = "MST"
        sMST.Msg = Message

        'Holds the bytes we are going to send
        Dim ByteArray() As Byte

        'Converts the structure to the byte array
        Dim Ptr As IntPtr = Marshal.AllocHGlobal(Marshal.SizeOf(sMST))
        ReDim ByteArray(Marshal.SizeOf(sMST) - 1)
        Marshal.StructureToPtr(sMST, Ptr, False)
        Marshal.Copy(Ptr, ByteArray, 0, Marshal.SizeOf(sMST))
        Marshal.FreeHGlobal(Ptr)

        'Send data
        SendData(ByteArray)
    End Sub

    '************ Send: MSS - MsgTypePack ************'
    Public Shared Sub MTC(ByVal Message As String, ByVal UniqueId As Byte, Optional ByVal Connection As Byte = Nothing)
        'Set packet data
        sMTC.Id = "MTC"
        sMTC.Msg = Message
        sMTC.UniqueId = UniqueId
        sMTC.Conn = Connection

        'Holds the bytes we are going to send
        Dim ByteArray() As Byte

        'Converts the structure to the byte array
        Dim Ptr As IntPtr = Marshal.AllocHGlobal(Marshal.SizeOf(sMTC))
        ReDim ByteArray(Marshal.SizeOf(sMTC) - 1)
        Marshal.StructureToPtr(sMTC, Ptr, False)
        Marshal.Copy(Ptr, ByteArray, 0, Marshal.SizeOf(sMTC))
        Marshal.FreeHGlobal(Ptr)

        'Send data
        SendData(ByteArray)
    End Sub
End Class
