// LFS Vertex Shader : CarToShadow


// Vertex shader input structure

struct VS_INPUT
{
	float4	v0		: POSITION;
};


// Vertex shader output structure

struct VS_OUTPUT
{
    float4	oPos	: POSITION;
	float	Height	: TEXCOORD;
};


// Global variables

float4x4	pmat			: register(c80);
float4x4	current_matrix	: register(c84); // mesh to world


// Main function

VS_OUTPUT vs_main( in VS_INPUT In )
{
	const float MIN_ALT = -20.0f; // these constants must match the ones in ShadowYoWorld.psh
	const float MAX_ALT = 160.0f;
	const float ALT_RANGE = MAX_ALT - MIN_ALT;
	
    VS_OUTPUT Out;

	Out.oPos = mul(In.v0, pmat);
	
	float4 v_world = mul(In.v0, current_matrix);

	// map altitude into a range from 0 to 1 to be stored in the green channel of a texture
	Out.Height = (v_world.z - MIN_ALT) / ALT_RANGE; // g = (h + 20) / 180
	
    return Out;
}