# LFS Autocross Editor Instruction Manual

*Note: Live for Speed must be unlocked to use the autocross editor*.

The autocross editor is accessed by pressing SHIFT+U inside the game.
In there you can save, load and edit layouts after switching on the
"place objects" option.

All the editor keys are listed on that screen.  The autocross system
works over the internet as well.  The host can edit / load a layout
while guests are connected.

To make an autocross layout, you place objects and checkpoints and a
start point.  If you don't place a start point, then it will use the
default start grid and will behave like a normal race track.  In that
case there will be no time penalties for hitting objects but you will
need to place checkpoints so that laps are timed.

Placing objects: select an object type and place an object by
pressing O.  You can adjust the direction (heading) of the object by
using the ',' and '.' keys.  If you press M with any object selected,
it will be moved to the mouse position and updated with the heading
that you have set.

Placing checkpoints: you need one finish line and at least one
checkpoint.  In effect this defines the circuit, and also gives you
split times at those points.  Pressing F or 1, 2, 3 gives you a finish
line or a checkpoint.  Checkpoints are invisible when driving.  You
should use cones or other objects to make sure the user takes the
correct route and drives through the checkpoints.  The W and E keys
can be used to set the width of a checkpoint.  As for objects,
press M to update a checkpoint's position, heading or width.

NOTE: direction is important with checkpoints.  You must drive over a
checkpoint in the correct direction or no time will be recorded.

A checkpoint looks like a square bracket, and you must drive FROM the
side with the "ends" of the square bracket and over TO the "flat side"
of the square bracket.

## Restricted areas and route control
In "marshall" mode you can place Marshall areas and Route checkers.

Marshall areas are shown by a red circle.  If a car enters one of them
in single player, it will receive a 1 minute penalty.  In multiplayer
mode, the player will be forced to spectate.

Route checkers are shown by a green circle.  Each route checker has a
route index number which is shown near the top right of the screen
when a route checker is selected.  Cars must pass through these route
checkers in the correct order, or they will receive a penalty or be
forced to spectate.  The route index is automatically generated in the
order the route checkers are created.  You can manually edit the route
index by clicking on the route index button.

## Controls
View control - mouse and keys - listed on screen.
Press V to toggle between high and low view.
Viewing the track - press SPACE to hide / show editor buttons.

Distance measurement: Press D to activate the measuring tool.

LFS - 6 July 2009