﻿#########################################
#ModuleName: 	#DragSystem
#Author: 		#Bass-Driver
#VersionDate: #07-06-2020
#Version: 		#0.4
#########################################
#Changelog:
#Version 0.1
#		-initial release
#Version 0.2
#	Edited:
#		-Extra command for !setspawnpoints.(!ssp)
#		-Spawn/Spec line now used to spawn players back (if a spawnpoint has been set, otherwise the driver will be spectated)
#	Fixed:
#		-Dragline Nodes removed after turning off the dragsystem.
#		-Set Draglines nodes(!sdl) as a spectator
#		-Set Spawnpoints(!ssp) as a spectator
#
#Version 0.3
#	Edited:
#		-Prestage lights does work now
#	Fixed:
#		-PreStage lines didnt work.
#
#Version 0.4
#	Fixed:
#		-Removed arguments from CloseDragResults() in Drag_Finish.lpr @ line 154
#
#########################################
CatchEvent OnLapperStart()

			GlobalVar $DragDriverPreStage; 
			
			$DragDriverPreStage[1] = "";
			$DragDriverPreStage[2] = "";
			$DragDriverPreStage[3] = "";
			$DragDriverPreStage[4] = "";
			
			GlobalVar $DragDriver1; 
			GlobalVar $DragDriver2;
			GlobalVar $DragDriver3;
			GlobalVar $DragDriver4;
			GlobalVar $DragGroup;
			GlobalVar $DragDriversLimit; #Set limit between 1 or 4
			
			GlobalVar $DragSplit1_1; 
			GlobalVar $DragSplit1_2;
			GlobalVar $DragSplit1_3;
			GlobalVar $DragSplit1_4;
			
			GlobalVar $DragSplit2_1; 
			GlobalVar $DragSplit2_2;
			GlobalVar $DragSplit2_3;
			GlobalVar $DragSplit2_4;
			
			GlobalVar $DragSplitFinish_1; 
			GlobalVar $DragSplitFinish_2;
			GlobalVar $DragSplitFinish_3;
			GlobalVar $DragSplitFinish_4;
			
			GlobalVar $DragAccDriver_1;
			GlobalVar $DragAccDriver_2;
			GlobalVar $DragAccDriver_3;
			GlobalVar $DragAccDriver_4;
			
			GlobalVar $DragEndSpeedDriver_1;
			GlobalVar $DragEndSpeedDriver_2;
			GlobalVar $DragEndSpeedDriver_3;
			GlobalVar $DragEndSpeedDriver_4;
			
			GlobalVar $PreStageLineNode;
			GlobalVar $StageLineNode;
			GlobalVar $FirstTimeLineNode;
			GlobalVar $SecondTimeLineNode;
			GlobalVar $FinishLineNode;
			GlobalVar $PenaltyLineNode;
			GlobalVar $AfterFinishNode;
			
			GlobalVar $DragWinner;
			GlobalVar $DragSystemOn;
			GlobalVar $DragStartActivated;
			GlobalVar $DragStarted;
			GlobalVar $GreenLightTime; #RandomTime(1-4 seconds) between last amberlight and greenlight
			GlobalVar $GreenLightsON;
			GlobalVar $AmberLightsON;
			GlobalVar $FinishedDrivers;
			GlobalVar $MaxFinishDrivers;
			GlobalVar $DragTimeStart; #Time when the lights turned GREEN
			GlobalVar $DriverCountToTeleport;
		
			
			$FinishedDrivers = 0; #How many drivers are finished
			$DriverCountToTeleport = 0;
			$MaxFinishDrivers = 0; #Check the drivers during the current dragrace
			$DragStartActivated = 0;
			$DragGroup = 1;
			$DragDriversLimit = 2;
			$DragSpotReady1 = "0";
			$DragSpotReady2 = "0";
			$DragSystemOn = "0";
			$DragStarted = "0";
			$AmberLightsON = "0"; 
			$GreenLightsON = "0";
			
			$PreStageLineNode = "-";
			$StageLineNode = "-";
			$FirstTimeLineNode = "-";
			$SecondTimeLineNode = "-";
			$FinishLineNode = "-";
			$PenaltyLineNode = "-";
			$AfterFinishNode = "-";
			
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event

	$idxOfFirtsSpace = indexOf( $text, " ");

	IF ($idxOfFirtsSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirtsSpace );
	  $argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF
SWITCH( $command )

#Set driverslimit for drag
CASE "!manydriverslimit": 
CASE "!mdl":
	IF($DragSystemOn == "1" )THEN
		IF(($argv < 4 )&&($argv > 0 )) THEN
			$DragDriversLimit = $argv;
			globalmsg("^3›^7Dragdriverlimit has been set to ^3".$DragDriversLimit." ^7drivers!");
		ELSE
			privmsg("^1›ERROR: ^7invalid value! (1 - 4)");
		ENDIF
	ELSE
		privMsg("^1ERROR: Command deniend > ^7Dragsystem is off!");
	ENDIF
BREAK;

#Turn Dragsystem on
CASE "!dragsystemon":
CASE "!dson":
IF($DragSystemOn == "0")THEN
	$DragSystemOn = "1";
	$DragStartActivated = 0;
	DragChristmasTree();
	globalmsg("^7DRAGSYSTEM IS TURNED ^2ON^7!!");
	globalmsg("^1START IS DEACTIVATED, DO NOT DRIVE TO THE STARTLINE!!!");
	privMsg("^6Commands: !draghelp");
ELSE
	privMsg("›Dragsystem already turned ^2ON^8!!!!!!");
ENDIF
BREAK;

#Turn Dragsystem off
CASE "!dragsystemoff":
CASE "!dsoff":
	IF($DragSystemOn == "1" )THEN
		$DragSystemOn = "0";
		ResetDrag();
		CloseDragSystem();
		globalmsg("DRAGSYSTEM IS TURNED ^1OFF^7!!!!");
	ELSE
	privMsg("›Dragsystem already turned ^1OFF^8!!!!!!");
	ENDIF
BREAK;

#Activate startlines after setting the dragsystem
CASE "!activatestart":
CASE "!acstart":
	IF($DragSystemOn == "1" )THEN
		IF (($StageLineNode != "-")&&($FinishLineNode != "-")) THEN
			$DragStartActivated = 1;
			openGlobalButton( "starty4",173,86,20,20,1,-1,0,"^2•");
			openGlobalButton( "starty41",177,86,20,20,1,-1,0,"^2•" );
			openGlobalButton( "starty42",183,86,20,20,1,-1,0,"^2•" );
			openGlobalButton( "starty43",187,86,20,20,1,-1,0,"^2•" );
			globalmsg("^2START IS ACTIVATED, DRIVE TO THE STARTLINE!!!");
			globalmsg("^2DRIVERSLIMIT SET TO: ^3".$DragDriversLimit);
			$Drivers = getListOfPlayers("N");
				FOREACH( $maVar IN $Drivers )
					SetPlayerVar($maVar["value"], "ReadyForDrag", "0");
					SetPlayerVar($maVar["value"], "DragPenalty", "0");
					SetPlayerVar($maVar["value"], "OnPreStageLine", "0");
				ENDFOREACH
			ResetDrag();
			DragChristmasTree();
		ELSE
			privMsg("^1›ERROR: ^7 No Start or Finishline detected!");
			privMsg("^7Cannot activate the startline!");
		ENDIF
	ENDIF
BREAK;

CASE "!deactivatestart":
CASE "!destart":
	IF($DragSystemOn == "1" )THEN
		$DragStartActivated = 0;
		globalmsg("^1START IS DEACTIVATED, DO NOT DRIVE TO THE STARTLINE!!!");
		DragChristmasTree();
	ENDIF
BREAK;

CASE "!resetdragsystem":
CASE "!rds":
	IF($DragSystemOn == "1" )THEN
		globalmsg("^3›^7DRAGSYSTEM RESET!");
		globalmsg("^3›^7DRAGSYSTEM RESET!");
		$Drivers = getListOfPlayers("N");
			FOREACH( $maVar IN $Drivers )
				SetPlayerVar($maVar["value"], "ReadyForDrag", "0");
				SetPlayerVar($maVar["value"], "DragPenalty", "0");
			ENDFOREACH
		CloseDragResults();
		ResetDrag();
		DragChristmasTree();
	ENDIF
BREAK;

CASE "!sdl":
CASE "!setdraglines":
	IF ($DragSystemOn == "1" ) THEN
		IF(GetPlayerVar( $userName , "OnTrack")) THEN
			DragSetLines($KeyFlags,$userName);
		ELSE
			privMsg("^3You must be on the track to use this command!");
		ENDIF
	ELSE
		privMsg("^1ERROR: Command deniend > ^7Dragsystem is off!");
	ENDIF
BREAK;

CASE "!dragratio":
	IF($DragSystemOn == "1" )THEN
		globalmsg( "Drag Win/Lose Ratio of: ". GetPlayerVar( $userName , "NickName"));
		IF(GetPlayerVar( $userName , "DragWin") > 0)THEN
			$Ratio = Round(ToNum(GetPlayerVar( $userName , "DragWin")/(GetPlayerVar( $userName , "DragLose") + GetPlayerVar( $userName , "DragWin"))*100),2);
		ENDIF
			globalmsg( "^8Total Dragrace: ^7" .(GetPlayerVar( $userName , "DragLose") + GetPlayerVar( $userName , "DragWin")));
			globalmsg( "^8Win/Lost Dragrace: ^2" .GetPlayerVar( $userName , "DragWin")."^7/^1".GetPlayerVar( $userName , "DragLose"));
			globalmsg( "^8Winning Ratio: ^7" .$Ratio. "%");
	ELSE
			privMsg("^1ERROR: Command deniend > ^7Dragsystem is off!");
	ENDIF
BREAK;
CASE "!dragversion":
	privMsg("DragAddon for LFSLapper: Version 0.2");
	privMsg("Made by: Bass-Driver");
BREAK;

CASE "!setspawnpoints":
CASE "!ssp":
IF ($DragSystemOn == "1" ) THEN
		IF(GetPlayerVar( $userName , "OnTrack")) THEN
			SpawnBack($KeyFlags,$userName);
		ELSE
			privMsg("^3You must be on the track to use this command!");
		ENDIF
ELSE
	privMsg("^1ERROR: Command deniend > ^7Dragsystem is off!");
ENDIF
BREAK;

CASE "!draghelp":
CASE "!dehe":
	privMsg("^3!draghelp ^8: Dragcommands (!dehe)");
	privMsg("^3!dragsystemon ^8: Dragsystem on (!dson)");
	privMsg("^3!dragsystemoff ^8: Dragsystem off (!dsoff)");
	privMsg("^3!setdraglines ^8: Set Start/Split/Finish lines (!sdl)");
	privMsg("^3!manydriverslimit ^8: Set Start/Split/Finish lines (!mdl)");
	privMsg("^3!activatestart ^8: Activate start after setting startlines (!acstart)");
	privMsg("^3!deactivatestart ^8: Activate start after setting lines (!destart)");
	privMsg("^3!resetdragsystem ^8: reset dragsystem when system is malfunctioning (!rds)");
	privMsg("^3!setspawnpoints ^8: Set Spawnpoint for the finishing drivers (!ssp)");
	privMsg("^3!dragratio ^8: Show your winningratio");
	privMsg("^3!dragversion ^8: Version of the current dragsystem");
BREAK;
ENDSWITCH
EndCatchEvent

CatchEvent OnConnect( $userName ) # Player event
IF($DragSystemOn == "1" )THEN
	DragChristmasTree();
	privMsg("^3A DRAGSYSTEM IS ENABLED , PLEASE FOLLOW THE RULES!!!");
	SetPlayerVar($userName, "ReadyForDrag", "0");
	SetPlayerVar($userName, "OnPreStageLine","0");
	SetPlayerVar($userName, "DragPenalty", "0");
	SetCurrentPlayerVar("DragLose", GetUserStoredValue( "DragTotLose" ));
	SetCurrentPlayerVar("DragWin", GetUserStoredValue( "DragTotWin" ));
	IF(GetCurrentPlayerVar("DragLose") == "") THEN
		SetCurrentPlayerVar("DragLose", 0);
	ENDIF
	IF(GetCurrentPlayerVar("DragWin") == "") THEN
		SetCurrentPlayerVar("DragWin", 0);
	ENDIF
ENDIF
EndCatchEvent

CatchEvent OnLeaveRace( $userName )  # Player event
IF ($DragSystemOn == "1" )THEN
	ResetDragUsers($userName);
ENDIF
EndCatchEvent

CatchEvent OnPit( $userName )  # Player teleported to pit () Shift + P )
IF ($DragSystemOn == "1" )THEN
	ResetDragUsers($userName);
ENDIF
EndCatchEvent

CatchEvent OnAcceleration( $userName )  # Player event
IF (($DragSystemOn == "1" )&&($DragStarted == "1")) THEN
	IF ($userName == $DragDriver1[$DragGroup]) THEN
			$DragAccDriver_1[$DragGroup] = GetCurrentPlayerVar("AccelerationTime");
	ENDIF
	IF ($userName == $DragDriver2[$DragGroup]) THEN
			$DragAccDriver_2[$DragGroup] = GetCurrentPlayerVar("AccelerationTime");
	ENDIF
	IF ($userName == $DragDriver3[$DragGroup]) THEN
			$DragAccDriver_3[$DragGroup] = GetCurrentPlayerVar("AccelerationTime");
	ENDIF
	IF ($userName == $DragDriver4[$DragGroup]) THEN
			$DragAccDriver_4[$DragGroup] = GetCurrentPlayerVar("AccelerationTime");
	ENDIF
ENDIF
EndCatchEvent

Sub CloseDragSystem()
	#Close Buttons
	CloseGlobalButton("dragbg&test1gbd2&test1gbd&&test1gbd0&test1gbd1&test1&test1gbd2&test1gbd3&test2&test21&test3&test31");
	CloseGlobalButton("prestaged1&prestaged2&prestaged3&prestaged4&staged1&staged2&staged3&staged4&dragr2&dragr1&test11");
	CloseGlobalButton("starty1&starty11&starty2&starty21&starty3&starty31&starty4&starty41&starty5&starty51&dragupper&dragupperdrv1name&dragupperdrv2name&dragupperdrv3name&dragupperdrv4name");
	CloseGlobalButton("starty12&starty13&starty22&starty23&starty32&starty33&starty42&starty43&starty52&starty53");
	CloseGlobalButton("dragupperbgd&dragupperdrv1title&dragupperdrv2title&dragupperdrv3title&dragupperdrv4title");
CloseDragResults();
EndSub

Sub DragChristmasTree()
	openGlobalButton( "dragupperbgd",50,0,100,8,5,-1,32, "");
	openGlobalButton( "dragupperdrv1title",50,0,25,3,5,-1,32, "^3Driver 1:");
	openGlobalButton( "dragupperdrv2title",75,0,25,3,5,-1,32, "^3Driver 2:");
	openGlobalButton( "dragupperdrv3title",100,0,25,3,5,-1,32, "^3Driver 3:");
	openGlobalButton( "dragupperdrv4title",125,0,25,3,5,-1,32, "^3Driver 4:");
	
	openGlobalButton( "dragbg",180,50,20,65,5,-1,32, "");
	openGlobalButton( "test1gbd0",180,54,20,5,5,-1,32, "");
	openGlobalButton( "test1gbd1",180,50,20,4,5,-1,32, "^7PreStage");
	openGlobalButton( "test1gbd2",180,59,20,4,5,-1,32, "^7Stage");
	openGlobalButton( "test1gbd3",180,63,20,5,5,-1,32, "");
	openGlobalButton( "test1",189,68,2,42,5,-1,32, "");
	openGlobalButton( "test11",189,68,2,3,3,-1,0, "^3L%nl%^7F%nl%^4S %nl%%nl%^7D%nl%^7R%nl%^7A%nl%^7G%nl%^7R%nl%^7A%nl%^7C%nl%^7I%nl%^7N%nl%^7G");
	
		openGlobalButton( "dragupperdrv1name",50,3,25,5,5,-1,16, "");
		openGlobalButton( "dragupperdrv2name",75,3,25,5,5,-1,16, "");
		openGlobalButton( "dragupperdrv3name",100,3,25,5,5,-1,16, "");
		openGlobalButton( "dragupperdrv4name",125,3,25,5,5,-1,16, "");

		openGlobalButton( "test31",180,110,20,5,5,-1,16, getLapperVar( "HostName" ));
		
		openGlobalButton( "prestaged1",176,49,14,14,1,-1,0,"^0•" );
		openGlobalButton( "prestaged2",180,49,14,14,1,-1,0,"^0•" );
		openGlobalButton( "prestaged3",186,49,14,14,1,-1,0,"^0•" );
		openGlobalButton( "prestaged4",190,49,14,14,1,-1,0,"^0•" );
		
		openGlobalButton( "staged1",176,58,14,14,1,-1,0,"^0•" );
		openGlobalButton( "staged2",180,58,14,14,1,-1,0,"^0•" );
		openGlobalButton( "staged3",186,58,14,14,1,-1,0,"^0•" );
		openGlobalButton( "staged4",190,58,14,14,1,-1,0,"^0•" );

		openGlobalButton( "starty1",173,62,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty11",177,62,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty12",183,62,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty13",187,62,20,20,1,-1,0,"^0•" );

		openGlobalButton( "starty2",173,70,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty21",177,70,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty22",183,70,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty23",187,70,20,20,1,-1,0,"^0•" );

		openGlobalButton( "starty3",173,78,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty31",177,78,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty32",183,78,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty33",187,78,20,20,1,-1,0,"^0•" );

		openGlobalButton( "starty4",173,86,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty41",177,86,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty42",183,86,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty43",187,86,20,20,1,-1,0,"^0•" );

		openGlobalButton( "starty5",173,94,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty51",177,94,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty52",183,94,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty53",187,94,20,20,1,-1,0,"^0•" );
	
	IF($DragStartActivated == 0) THEN
	 
		openGlobalButton( "dragupperdrv1name",50,3,25,5,5,-1,16, "^1X");
		openGlobalButton( "dragupperdrv2name",75,3,25,5,5,-1,16, "^1X");
		openGlobalButton( "dragupperdrv3name",100,3,25,5,5,-1,16, "^1X");
		openGlobalButton( "dragupperdrv4name",125,3,25,5,5,-1,16, "^1X");
		
		openGlobalButton( "starty4",173,86,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty41",177,86,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty42",183,86,20,20,1,-1,0,"^0•" );
		openGlobalButton( "starty43",187,86,20,20,1,-1,0,"^0•" );
		
		openGlobalButton( "starty5",173,94,20,20,1,-1,0,"^1•%at%^0•" );
		openGlobalButton( "starty51",177,94,20,20,1,-1,0,"^1•%at%^0•" );
		openGlobalButton( "starty52",183,94,20,20,1,-1,0,"^1•%at%^0•" );
		openGlobalButton( "starty53",187,94,20,20,1,-1,0,"^1•%at%^0•" );
	ENDIF
EndSub