
import struct
filePath = "C:/Documents and Settings/Test/Omat tiedostot/LFSSkinviewer/data/"
fileToLoad = "RB4 - RB4 GT"

outputDir = "C:/Documents and Settings/Test/Omat tiedostot/LFSSkinviewer/"
outputFileName = "test"

uniqueNumberInternal = 0

def uniqueNumber():
    global uniqueNumberInternal
    uniqueNumberInternal += 1
    return uniqueNumberInternal

def unpackColor(x):
    return (ord(x[1])/255.0,ord(x[2])/255.0,ord(x[3])/255.0,(255-ord(x[0]))/255.0)

def int2m(x):
    return x/65536.0

def readIntm(f):
    return int2m(readInt(f))

def readInt(f):
    return struct.unpack("i",f.read(4))[0]

def readFloat(f):
    s = f.read(4)
    try:
        return struct.unpack("f",s)[0]
    except:
        print s
        raise sys.exception

def readWord(f):
    return struct.unpack("h",f.read(2))[0]

def unpackString(x):
    s = ''
    for c in x:
        if ord(c)==0:
            break
        s += c
    return s


class XYZ:
    def __init__(self):
        self.x = 0
        self.y = 0
        self.z = 0
    def read(self,f):
        self.x = readIntm(f)
        self.y = readIntm(f)
        self.z = readIntm(f)
    def readAsFloats(self,f):
        self.x = readFloat(f)
        self.y = readFloat(f)
        self.z = readFloat(f)
    def __str__(self):
        return str((self.x,self.y,self.z))
    def exportToObj(self):
        return str(self.x)+" "+str(self.y)+" "+str(self.z)

class Point:
    def __init__(self):
        self.p = XYZ()
        self.n = XYZ()
        self.uv = ()
        self.color = (0,0,0,1)
    def read(self,f):
        self.p.read(f)
        self.n.readAsFloats(f)
        self.uv = (readFloat(f),readFloat(f))
        self.color = unpackColor(f.read(4))
    def __str__(self):
        return str(map(str,(self.p,self.n,self.uv,self.color)))
    def exportToObj(self,v,vn,vt):
        return (v+1,vn+1,vt+1,"v "+self.p.exportToObj()+"\nvn "+self.n.exportToObj()+"\nvt "+str(1.0-self.uv[0])+" "+str(self.uv[1])+"\n")

class TextureBlock:
    def __init__(self):
        self.flags = 0
        self.textureIndex = 0
        self.surfaceType = 0
        self.numPoints = 0
        self.numTris = 0
    def read(self,f):
        self.flags = ord(f.read(1))
        zero = ord(f.read(1))
        self.textureIndex = ord(f.read(1))
        self.surfaceType =  ord(f.read(1))
        if zero!=0:
            print "zero returned : ",zero
            print "self:",str(self)
            raise "Not a valid texture block"
        self.numPoints = readWord(f)
        self.numTris = readWord(f)
    def __str__(self):
        return str((self.textureIndex,self.surfaceType,self.flags,self.numPoints,self.numTris))

class Object:
    def __init__(self):
        self.centre = XYZ()
        self.radius = 0.0
        self.configs = None
        self.flags = 0
        self.numTextures = 0
        self.numPoints = 0
        self.numTris = 0
    def read(self,f):
        self.centre.read(f)
        self.radius = readIntm(f)
        self.configs = readWord(f)
        self.flags = readWord(f)
        self.numTextures = readWord(f)
        self.numPoints =  readWord(f)
        self.numTris = readWord(f)
        zero = readWord(f)
        print "centre:",self.centre
        print "radius:",self.radius
        print "flags:",self.flags
        print "numTextures:",self.numTextures
        print "numPoints:",self.numPoints 
        print "numTris:",self.numTris 
        if int(zero)!=0:
            raise "Not a valid object block" 
        self.textures = []
        for i in range(self.numTextures):
            self.textures.append(TextureBlock())
            self.textures[-1].read(f)
            print "\t"+str(self.textures[-1])
        self.points = []
        for i in range(self.numPoints):
            self.points.append(Point())
            self.points[-1].read(f)
        self.tris = []
        for i in range(self.numTris):
            (a,b,c,fl) = struct.unpack("hhhh",f.read(8))
            self.tris.append((a,b,c,fl))
    def exportToObj(self,v,vn,vt,textureMap):
        s = ''
        (oldv,oldvn,oldvt) = (v,vn,vt)
        for i in range(len(self.points)):
            (v,vn,vt,ss) = self.points[i].exportToObj(v,vn,vt)
            s += ss
        triOffset = 0
        for t in self.textures:
            s += 's object'+str(uniqueNumber()) + '\n'
            s += 'g object'+str(uniqueNumber()) + '\n'
            if t.textureIndex in textureMap:
                s += "usemtl " + textureMap[t.textureIndex][0] + "\n"
            else:
                s += "usemtl None\n"
            for i in range(t.numTris):
                a = self.tris[i+triOffset][0]+1
                b = self.tris[i+triOffset][1]+1
                c = self.tris[i+triOffset][2]+1
                (an,bn,cn) = (a,b,c)
                (at,bt,ct) = (a,b,c)
                s += "f %d/%d/%d %d/%d/%d %d/%d/%d\n" % (a+oldv,an+oldvn,at+oldvt,b+oldv,bn+oldvn,bt+oldvt,c+oldv,cn+oldvn,ct+oldvt)
            triOffset += t.numTris
        return (v,vn,vt,s)
        

class CarCMX:
    def __init__(self):
        pass
    def readFile(self,filePath,fileToLoad):
        f = open(filePath+"cmx/"+fileToLoad+".cmx","rb")
        self.fileType = f.read(6)
        if self.fileType!="LFSCMX":
            return (False,"File is not a CMX")
        ignore = f.read(2)
        self.cmxVersion = ord(f.read(1))
        if self.cmxVersion!=0:
            return (False,"Only CMX version 0 is supported, found version " + 

str(cmxVersion))
        self.cmxType = ord(f.read(1))
        if self.cmxType!=1:
            return (False,"Only Car CMX's are supported")
        ignore = f.read(6)
        self.cmxName = unpackString(f.read(32))
        print "cmxName:",self.cmxName
        # skipping next fields
        ignore = f.read(20)
        self.numLightSchemes = readInt(f)
        print "numLightSchemes:",self.numLightSchemes
        self.numConfigs = readInt(f)
        print "numConfigs:",self.numConfigs
        self.numTextures = readInt(f)
        print "numTextures:",self.numTextures
        self.numObjects = readInt(f)
        print "numObjects:",self.numObjects

        self.readLightSchemeBlock(f,self.numLightSchemes)
        self.readConfigBlocks(f,self.numConfigs)
        self.readTextureBlocks(f,self.numTextures)
        self.readObjectBlocks(f,self.numObjects)
        f.close()
    def readLightSchemeBlock(self,f,n):
        for i in range(n):
            ignore = f.read(72)
    def readConfigBlocks(self,f,n):
        for i in range(n):
            ignore = f.read(16)
            numNodes = unpackInt(f.read(4))
            for j in range(n):
                ignore = f.read(40)
    def readTextureBlocks(self,f,n):
        self.textures = []
        for i in range(n):
            self.textures.append( (unpackString(f.read(16)),readInt(f)) )
        print self.textures

    def readObjectBlocks(self,f,n):
        self.objects = []
        for i in range(n):
            self.objects.append(Object())
            self.objects[-1].read(f)

    def exportToObj(self):
        s = ''
        (v,vn,vt) = (0,0,0)
        textureMap = {}
        for i in range(len(self.textures)):
            textureMap[i] = self.textures[i]
        for i in range(len(self.objects)):
            (v,vn,vt,ss) = self.objects[i].exportToObj(v,vn,vt,textureMap)
            s += ss
            print (v,vn,vt)
        return s

    def exportToMtl(self):
        s = ''
        for t in self.textures:
            if len(t[0])>0 and t[1]==192:
                s += "newmtl " + t[0] + "\n"
                s += "map_Kd " + t[0] + ".jpg \n"
            else:
                s += "newmtl " + t[0] + "\n"
                if t[0][-5:]=="ALPHA":
                    s += "d 0.1\n"    # almost fully transparant blue windows
                    s+= 'Ka 0.0435 0.0435 0.9435\n'
                    s+= 'Kd 0.0086 0.0086 0.9086\n'
                    s+= 'Ks 1.0000 1.0000 1.0000\n'
                    s+= 'illum 4\n'  # glass
                else:
                    s+= 'Ka 0.0435 0.0435 0.0435\n'
                    s+= 'Kd 0.9086 0.9086 0.9086\n'
                    s+= 'Ks 1.0000 1.0000 1.0000\n'
                    s += 'illum 2\n'        # normal lighting
        return s

        
C = CarCMX()
C.readFile(filePath,fileToLoad)

#f = open(filePath+fileToLoad+".obj","w")
f = open(outputDir+outputFileName+".obj","w")
f.write("mtllib "+outputFileName+".mtl\n"+C.exportToObj())
f.close()

f = open(outputDir+outputFileName+".mtl","w")
f.write(C.exportToMtl())
f.close()
print "done"