<?php
/**
 * @file makelfslink.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons 
 */
    
/**
 * Utility function to make a Join2LFS compatible link. 
 *
 * @version 1.0.00
 * @param host (Array) An array with host data from the hosts lister, or an assoc array with indexes 'hostName', 'rules' and 'serverType' set.
 * @return (String) A Join2LFS compatible string.
 */
function makeLFSLink($host)
{
    if(!is_array($host) ||
       !isset($host['hostName']) ||
       !isset($host['rules']) ||
       !isset($host['serverType']))
            return false;
	$out = 'lfs://|';
	$out .= htmlentities($host['hostName']) . '|';
	$out .= ($host['rules'] & 8) ? ('1|') : ('0|');
	$out .= ($host['serverType'] == 0) ? ('S1') : ('S2');
	return $out.'|/';
}
?> 
