<?php
/**
 * @file decompress.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons 
 */

/**
 * Decompress data from LFS-World according to the integer format code. 
 *
 * @version 1.0.00
 * @param data (String) The raw compressed LFS-World data.
 * @param type (Mixed) The LFS-World integer format code.
 * @return (Mixed) Uncompressed string on success, false on failure.
 */
function PPFDecompress($data, $type)
{
    $uData = false;
    if($type == 1)
        $uData = @gzinflate(substr($data, 10));
    else if($type == 2)
        $uData = @gzuncompress($data);
    else if($type == 3)
        $uData = @gzinflate($data);

    return $uData;
}

/**
 * Performs a server check to make sure that the specified compression type can be decoded on this server.
 *
 * @version 1.0.00
 * @param type (Integer) LFS-World integer compression format code. 
 * @return (Boolean) True if the data can be decompressed, false otherwise.
 */
function PPFCanDecompress($type)
{
    switch($type)
    {
        case 1:
        case 3:
            if(function_exists('gzinflate'))
                return true;
            break;
        case 2:
            if(function_exists('gzuncompress'))
                return true;
            break;
    }

    return false;
}
        
?>
