<?php
/**
 * @file bitstoarray.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

    
/**
 * A lookup utility function to convert a bitfield in to an array
 *
 * @version 1.1.00
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 * @param num (Integer) The bitfield value to convert.
 * @return (Array) An array representing the bitfield.
 */ 
function bitsToArray($num)
{
    $output = array();
    $current = 1;
    $count = 0;
    while($current <= $num)
    {
        if($current & $num)
            $output[] = $current;

        $current = pow(2, ++$count);
    }

    return $output;
}
?>
