<?php
/**
 * Merges two arrays and replace existing Entrys
 *
 * Merges two Array like the PHP Function array_merge_recursive.
 * The main difference is that existing Keys will be replaced with new Values,
 * not combined in a new Sub Array.
 *
 * Usage:
 *        $newArray = array_merge_replace( $array, $newValues );
 *
 * @public
 * @author Tobias Tom <t.tom@succont.de>
 * @param array (Array) First Array with 'replaceable' Values.
 * @param newValues (Array) Array which will be merged into first one.
 * @return (Array) Resulting Array from replacing Process.
 */
function array_merge_replace( $array, $newValues ) {
   foreach ( $newValues as $key => $value ) {
       if ( is_array( $value ) ) {
               if ( !isset( $array[ $key ] ) ) {
               $array[ $key ] = array();
           }
           $array[ $key ] = array_merge_replace( $array[ $key ], $value );
       } else {
           if ( isset( $array[ $key ] ) && is_array( $array[ $key ] ) ) {
               $array[ $key ][ 0 ] = $value;
           } else {
               if ( isset( $array ) && !is_array( $array ) ) {
                   $temp = $array;
                   $array = array();
                   $array[0] = $temp;
               }
               if( is_object( $value ) ) {
                   $array[ $key ] =& $newValues[ $key ];
               } else {
                   $array[ $key ] = $value;
               }
           }
       }
   }
   return $array;
}
?>

