<?php
/**
 * Provides a class for parsing pb lists from LFSWorld.
 *
 * @file pb.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Include base provider class. 
 */
require_once(dirname(__FILE__).'/base.php');    
 
/**
 * Class for parsing LFSWorld PB lists.
 * 
 * @class LFSWorldPersonalBests
 * @version 2.0.00
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */
class LFSWorldPersonalBests extends LFSWorldDataProvider
{
    /**
	 * The base url of this data source.
	 * @protected
	 */
	var $m_sURL = 'http://www.lfsworld.net/pubstat/get_stat2.php?action=pb';
	
	/**
	 * An array of meta data possibly useful to other parts of a program. (Such as tarpit duration)
	 * @protected
	 */
    var $m_aSrcMetaData = array('lifeTime' => 60, 'actualTarpit' => 5);

    /**
     * Parses an individual line entry from LFSWorld.
	 *
	 * Raw entry format
	 *
	 * <pre>
	 * requires:&racer=RACER
     * optional:-
     * returns:TRACK CAR TIME LAP_COUNT
     * </pre>
     *
	 * @protected
	 * @see LFSWorldDataProvider::parse()
	 * @param line (String) The raw chunk to be parsed
	 * @return (Array) The parsed entry as an array.
     */
    function _parseLine($line)
    {
        $return = array();
        $line = explode(' ', $line);
        $return['track'] = array_shift($line);
        $return['car'] = array_shift($line);
        $return['time'] = array_shift($line);
        $return['laps'] = array_shift($line);
        return $return;
    }
    
    /**
     * Checks and adjusts input parameters where required & possible.
	 *
	 * @public
	 * @param params (&Array) An array of the params that are set.
	 * @return (Boolean) True if the parameters are ok, false otherwise.
     */
	function initParams(&$params)
	{
		return (parent::initParams($params) && isset($params['racer']));
	}
}

?>
