<?php
/**
 * Provides a class for parsing hotlap lists from LFSWorld.
 *
 * @file hl.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Include base provider class. 
 */
require_once(dirname(__FILE__).'/base.php');    

/**
 * Class for parsing LFSWorld hotlaps list.
 * 
 * @class LFSWorldHotlaps
 * @version 2.1.00
 */
class LFSWorldHotlaps extends LFSWorldDataProvider
{
    /**
	 * (String) The base url of this data source.
	 * @protected
	 */
	var $m_sURL = 'http://www.lfsworld.net/pubstat/get_stat2.php?action=hl';
	
	/**
	 * (Array) An array of meta data possibly useful to other parts of a program. (Such as tarpit duration)
	 * @protected
	 */
    var $m_aSrcMetaData = array('lifeTime' => 60, 'actualTarpit'=>5);
    
    /**
     * Parses an individual line entry from LFSWorld.
	 *
	 * Raw entry format
	 *
	 * <pre>
	 * requires:&racer=RACER
     * optional:-
     * returns:TRACK CAR TIME FLAGS_HLAPS
     * </pre>
     *
	 * @protected
	 * @see LFSWorldDataProvider::parse()
	 * @param line (String) The raw chunk to be parsed
	 * @return (Array) The parsed entry as an array.
     */
    function _parseLine($line)
    {
        //@TODO test speeds of old & new + bug check. Migrate if it is significantly better
        /*$return = array();
        $line = explode(' ', $line);
        $return['id_hl'] = array_shift($line);
        $return['track'] = array_shift($line);
        $return['car'] = array_shift($line);
        $return['time'] = array_shift($line);
        $return['flags'] = array_shift($line);*/
        list($r['id_hl'], $r['track'], $r['car'], $r['time'], $r['flags']) = explode(' ', $line);
        return $r;
    }
    
    /**
     * Checks and adjusts input parameters where required & possible.
	 *
	 * @public
	 * @param params (&Array) An array of the params that are set.
	 * @return (Boolean) True if the parameters are ok, false otherwise.
     */
	function initParams(&$params)
	{
        if(!isset($params['version']) || $params['version'] != 1.2)
            $params['version'] = 1.2;
		return (parent::initParams($params) && isset($params['racer']));
	}
}

?>
