<?php
/**
 * Provides a simple lookup mechanism to lookup common control method formats in LFS.
 *
 * @file rules.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Include base lookup
 */
if(!class_exists('PPFBaseLookup'))
    include dirname(__FILE__).'/baselookup.php';
    
/**
 * Static class for creating lookup arrays between commonly used formats to represent control methods in LFS.
 *
 * @class PPFRules
 * @version 1.0.00
 * @todo Get control flag definitions and complete class
 */
class PPFControlMethods extends PPFBaseLookup
{
    /**
     * Public function for retrieving a lookup array from one format to another.
     *
     * @public
     * @param from (String) The source format. Valid values are 'bits', 'codes', 'words'.
     * @param to (String) The target format. Valid values are 'bits', 'codes', 'words'.
     * @return (Array) An array providing a bridge between the two specified formats.
     **/
    function getLookupArray($from, $to, $ignore=array())
    {
        static $indexes;

        if($indexes == null)
        {
            $indexes =  array(  'bits'=>array(  1,
                                                2,
                                                4,
                                                8,
                                                16,
                                                32,
                                                64),

                                'words'=>array( 'Vote',
                                                'Select',
                                                'Qualify',
                                                'Private',
                                                'Modified',
                                                'Mid race join',
                                                'Must pit'),

                                'codes'=>array( 'v',
                                                's',
                                                'q',
                                                'p',
                                                'm',
                                                'j',
                                                't'),
                                                
								'lfswcodes'=>array(	'V',
											'S',
											'Q',
											'P',
											'M',
											'<span style="font-style: italic;">j</span>',
											'<span style="font-style: italic;">p</span>'));
        }

        return parent::getBaseLookup($indexes, $from, $to, $ignore);
    }
}
?>
