<?php
/**
 * @file errorcheck.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Utility function to check a string to see if it is a known LFSWorld error string.
 *
 * @version 1.1.00
 * @param string (String) The string to check.
 * @return (Boolean) True if the string is a known LFSWorld error, false otherwise.
 */
function isLFSWorldError($string)
{
    switch(trim(substr($string, 0, 50)))
    {
        case 'hl: no hotlaps found':
        case 'hl: no racer':
        case 'ch: invalid track':
        case 'ch: invalid car':
        case 'pst: no valid username':
        case 'pb: racer has no pbs':
        case 'no output':
        case 'can\'t reload this page that quickly after another':
        case 'hl_log is only available since version 1.2 and later':
        case '':
            return true;
    }

    return false;
}

?>
