<?php
include('../lfswinterface.php');
include('../caches/lfsworldfilecache.php');
include('../utilities/stringproc.php');

//Init LFSWorld Interface
$lfsw = new LFSWInterface();
//Get hosts list
$hosts = $lfsw->getHostList();
//Get instance of String proc (for colour and codepage parsing)
$sProc =& LFSStringProc::singleton();

?>
<html>
  <head>
    <title>LFSW-PPF Host list sample</title>
  </head>
  <body>
<?php if($hosts['success']): ?>
    <table>
      <thead>
        <tr>
          <th>Hostname</th>
          <th>Track</th>
          <th>Version</th>
          <th>Players / Max</th>
        </tr>
      </thead>
      <tbody>
<?php foreach($hosts['data'] as $host): ?>
        <tr>
          <td><?=$sProc->process($host['host_name']) ?></td>
          <td><?=$host['track'] ?></td>
          <td><?=$host['major_version'].$host['minor_version'] ?></td>
          <td><?=$host['players'] ?> / <?=$host['max_players'] ?></td>
        </tr>
<?php endforeach; ?>
      </tbody>
      <tfoot>
        <tr>
          <td>Hostname</td>
          <td>Track</td>
          <td>Version</td>
          <td>Players / Max</td>
        </tr>
      </tfoot>
    </table>
<?php else: ?>
    <p>Error!</p>
<?php foreach($hosts['errors'] as $entry): ?>
    <p><?=$entry ?></p>
<?php endforeach; ?>
<?php endif; ?>
  </body>
</html>