<?php
/**
 * Provides a class for parsing chart lists from LFSWorld.
 *
 * @file ch.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons 
 */

/**
 * Include Base provider class
 */
require_once(dirname(__FILE__).'/base.php');     
 
/**
 * Class for parsing LFSWorld chart list.
 * 
 * @class LFSWorldChart
 * @version 2.0.00
 */
class LFSWorldChart extends LFSWorldDataProvider
{
    /**
	 * (String) The base url of this data source.
	 * @protected
	 */
	var $m_sURL = 'http://www.lfsworld.net/pubstat/get_stat2.php?action=ch';
	
	/**
	 * (Array) An array of meta data possibly useful to other parts of a program. (Such as tarpit duration)
	 * @protected
	 */
    var $m_aCacheData = array('lifeTime' => 60, 'actualTarpit'=>5);

    /**
     * Parses an individual line entry from LFSWorld.
	 *
	 * Raw entry format
	 *
	 * <pre>
	 * requires:&track=TRACK&car=CAR
     * optional:&control=STEERING
     * returns:TIME FLAGS_HLAPS RACERNAME
     * </pre>
     *
	 * @protected
	 * @see LFSWorldDataProvider::parse()
	 * @param line (String) The raw chunk to be parsed
	 * @return (Array) The parsed entry as an array.
     */
    function _parseLine($line)
    {
        $return = array();
        $line = explode(' ', $line);
        $return['time'] = array_shift($line);
        $return['flags'] = array_shift($line);
        $return['racer'] = implode(' ', $line);
        
        return $return;
    }
    
    /**
     * Checks and adjusts input parameters where required & possible.
	 *
	 * @public
	 * @param params (&Array) An array of the params that are set.
	 * @return (Boolean) True if the required parameters are set, false otherwise.
     */
	function initParams(&$params)
	{
		return (parent::initParams($params) && isset($params['car']) && isset($params['track']));
	}
}

?>
