<?php
/**
 * Provides a simple lookup mechanism to lookup common track formats in LFS.
 *
 * @file tracks.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Include base lookup
 */
if(!class_exists('PPFBaseLookup'))
    include dirname(__FILE__).'/baselookup.php';

/**
 * Static class for creating lookup arrays between commonly used formats to represent tracks in LFS.
 *
 * @class PPFTracks
 * @version 1.0.00
 * @author Michael Simons <ixulai@gmail.com> 
 **/
class PPFTracks extends PPFBaseLookup
{
    /**
     * Public function for retrieving a lookup array from one format to another.
     *
     * @public
     * @param from (String) The source format. Valid values are 'int', 'codes', 'words'.
     * @param to (String) The target format. Valid values are 'int', 'codes', 'words'.
     * @return (Array) An array providing a bridge between the two specified formats.
     **/
    function getLookupArray($from, $to)
    {
        static $indexes;

        if($indexes == null)
        {
            $indexes = array('int'=>array(  '000', '001', '010', '011', '020',
                                            '100', '101', '110', '111', '120', '121', '130', '131', '140', '141',
                                            '200', '201', '210', '211', '220', '221', '230', '231', '240', '241', '250', '251',
                                            '300', '310', '320', '330',
                                            '400', '401', '410', '411', '420', '421',
                                            '500', '501',
                                            '600', '601', '610', '611', '620', '621', '630', '631', '640', '641'),

                            'codes'=>array( 'BL1', 'BL1R', 'BL2', 'BL2R', 'BL3',
                                            'SO1', 'SO1R', 'SO2', 'SO2R', 'SO3', 'SO3R', 'SO4', 'SO4R', 'SO5', 'SO5R',
                                            'FE1', 'FE1R', 'FE2', 'FE2R', 'FE3', 'FE3R', 'FE4', 'FE4R', 'FE5', 'FE5R', 'FE6', 'FE6R',
                                            'AU1', 'AU2',  'AU3', 'AU4',
                                            'KY1', 'KY1R', 'KY2', 'KY2R', 'KY3', 'KY3R',
                                            'WE1', 'WE1R',
                                            'AS1', 'AS1R', 'AS2', 'AS2R', 'AS3', 'AS3R', 'AS4', 'AS4R', 'AS5', 'AS5R'),

                            'words'=>array( 'Blackwood GP', 'Blackwood GP reversed', 'Blackwood RallyX', 'Blackwood RallyX reversed', 'Blackwood Car park',
                                            'South city Classic', 'South city Classic reversed', 'South city Sprint track 1', 'South city Sprint track 1 reversed',
                                                'South city Sprint track 2', 'South city Sprint track 2 reversed', 'South city Long', 'South city Long reversed',
                                                'South city Town course', 'South city Town course reversed',
                                            'Fern bay Club', 'Fern bay Club reversed', 'Fern bay Green', 'Fern bay Green reversed', 'Fern bay Gold', 'Fern bay Gold reversed',
                                                'Fern bay Black', 'Fern bay Black reversed', 'Fern bay Rallycross', 'Fern bay Rallycross reversed', 'Fern bay Rally X Green',
                                                'Fern bay Rally X Green reversed',
                                            'Autocross', 'Autocross Skid pad', 'Autocross Drag strip', 'Autocross 8 lane drag strip',
                                            'Kyoto ring Oval', 'Kyoto ring Oval reversed', 'Kyoto ring National', 'Kyoto ring National reversed', 'Kyoto ring GP long', 'Kyoto ring GP long reversed',
                                            'Westhill International', 'Westhill International reversed',
                                            'Aston Cadet', 'Aston Cadet reversed', 'Aston Club', 'Aston Club reversed', 'Aston National', 'Aston National reversed',
                                                'Aston Historic', 'Aston Historic reversed', 'Aston Grand prix', 'Aston Grand prix reversed'));
        }

        return parent::getLookupArray($indexes, $from, $to, array());
    }
}
?>
